/**
 * @fileoverview
 * (This file was autogenerated by hob)
 * 
 * The application is created in two steps:
 *
 * Step 1: All objects that do not depend on the services available from the
 *         debuggee. The only exception is the scope service, as it is needed
 *         to query the debuggee about what services it provides. All scope
 *         debuggees run the scope service, and it can not be disabled.
 *
 * Step 2: All service objects are created, based on their counterpart on
 *         the debuggee side. The second step uses
 *         a pattern where each service has a build function in
 *         "app.builders.<servuce class name>.<service version>.
 *         The builders are called as soon as service information have been
 *         received from the scope service. It's possible to hook up a callback
 *         after the second step has finished. The callback can either be
 *         passed as an argument to the build_application call, or by defining
 *         a function named window.app.on_services_created, which
 *         will be called automatically
 *
 * 
 * There is an other moment to hook up a callback. 
 * That is when all services are sucessfully enabled.
 * The callback can either be passed to the build_application call 
 * as second argument or by defining a function named 
 * window.app.on_services_enabled
 * 
 */
if( window.app )
{
  throw "window.app does already exist";
}
window.app = {};
window.cls.MessageMixin.apply(window.app); // Give the app object message handling powers

window.app.build_application = function(on_services_created, on_services_enabled)
{

  var _find_compatible_version = function(version, version_list)
  {
    var
    numbers = version.split(".").map(Number),
    match = null,
    ver, nums;
     // Find the best match for the current version
    for (ver in version_list)
    {
      nums = ver.split(".").map(Number);
      if (nums[0] != numbers[0])
        continue;
      if (!match || nums[1] > match[1][1])
        match = [ver, nums];
    }
    return match && match[0];
  }

  var on_host_info_callback = function(service_descriptions)
  {
    % if create_test_framework:
    new window.cls.ScopeInterfaceGenerator().get_interface(service_descriptions, 
      function(map)
      {
        window.message_maps = map;
        window.cls.ServiceBase.populate_map(map);
        build_and_enable_services(service_descriptions, map);
        window.test_framework.rebuild_last_state();
      }, 
      function(error)
      {
        opera.postError(error.message);
      }
    );
    % else:
    build_and_enable_services(service_descriptions);
    % endif
  };

  /**
   * This callback is invoked when host info is received from the debuggee.
   *
   */
  var build_and_enable_services = function(service_descriptions, map)
  {
    var 
    service_name = '',
    service = null,
    class_name = '',
    re_version = /(^\d+\.\d+)(?:\.\d+)?$/,
    version = null,
    i = 0,
    builder = null,
    numbers = null;

    for (service_name in service_descriptions)
    {
      service = service_descriptions[service_name];
      version = re_version.exec(service.version);
      version = version && version[1] || "0";
      class_name = window.app.helpers.dash_to_class_name(service_name);
      if (service_name != "scope")
      {
        if (window.services[service_name] && 
          window.services[service_name].create_and_expose_interface(version, map[service_name]))
        {
          var
          match_version = _find_compatible_version(version, window.app.builders[class_name]),
          builder = window.app.builders[class_name] && window.app.builders[class_name][match_version];
          if (builder) 
          {
            builder(service);
          }
        }
      }
    }
    window.app.post('services-created', {'service_description': service_descriptions});
    if (window.app.on_services_created)
    {
      window.app.on_services_created(service_descriptions);
    }
    if (on_services_created)
    {
      on_services_created(service_descriptions);
    }
    for (service_name in service_descriptions)
    {
      if(service_name in window.services && 
            window.services[service_name].is_implemented &&
            service_name != "scope")
      {
        window.services['scope'].requestEnable(0,[service_name]);
      }
    }
  }

  var create_raw_interface = function(service_name)
  {
    var ServiceClass = function()
    {
      this.name = service_name;
      this.is_implemented = false;
    }
    ServiceClass.prototype = new cls.ServiceBase();
    ServiceClass.prototype.constructor = ServiceClass;  // this is not really needed
    window.services.add(new ServiceClass());
  }

  // ensure that the static methods on cls.ServiceBase exist.
  new cls.ServiceBase();

  % if create_test_framework:
  window.test_framework = new cls.TestFramework();
  window.logger = new cls.Logger();
  window.document.onclick = window.test_framework.get_bound_click_handler();
  window.document.onchange = window.test_framework.get_bound_change_handler();
  % endif

  // global objects
  window.tagManager = new window.cls.TagManager();
 
  // create window.services namespace and register it.
  cls.ServiceBase.register_services(new cls.Namespace("services"));
  [
  % for service in services:
    '${dashed_name(service.name)}',
  % endfor
  ].forEach(create_raw_interface);
% for service in services:
  % if service.name == "Scope":
  var namespace = cls.${service.name} && cls.${service.name}["${service.options["version"].value}"];
  namespace.Service.apply(window.services.scope.constructor.prototype);
  window.services.scope.is_implemented = true;
  window.services.scope.set_host_info_callback(on_host_info_callback);
  window.services.scope.set_services_enabled_callback(on_services_enabled);
  % endif
% endfor

  // create the client
  if(window.services.scope)
  {
    window.client = new cls.Client();
    client.setup();
  }
  else
  {
    throw "scope service couldn't be created, application creation aborted";
  }
}

/**
  * The builders for each service and version.
  * These calls can also be used to create other parts of the application
  * which support a given service version.
  * It is recommended ( but not required ) that classes which support a given
  * service version are organized in an appropirate namespace, like
  * ls.<service class name>.<service version>.
  */
window.app.builders = {};
% for service in services:
  % if not service.name == "Scope":
window.app.builders.${service.name} || ( window.app.builders.${service.name} = {} );
/**
  * @param {Object} service the service description of the according service on the host side
  */
<% version = '.'.join(service.options["version"].value.split('.')[:2]) %>\
window.app.builders.${service.name}["${version}"] = function(service)
{
  var namespace = cls.${service.name} && cls.${service.name}["${version}"];
    % if create_test_framework:
      % if service.name == "EcmascriptDebugger":
  window.runtimes = new namespace.Runtimes();
  window.dom = new namespace.DOM();
      % elif service.name == "WindowManager":
  window.windows = new namespace.Windows();
      % endif
    % endif
}

  % endif
% endfor

window.app.helpers = {};

window.app.helpers.dash_to_class_name = function(name)
{
  for ( var cur = '', i = 0, ret = '', do_upper = true; cur = name[i]; i++)
  {
    if(cur == '-')
    {
      do_upper = true;
      continue;
    }
    ret += do_upper && cur.toUpperCase() || cur;
    do_upper = false;
  }
  return ret;
}

window.onload = function()
{
  window.app.build_application();
  % if console_logger_tutorial:
  window.simple_logger = new SimpleLogger();
  % endif
}

