<%
  INDENT = indent or '  '
  local_comments = comments or ["/** \n", "  * ", "  */"]
  version = ".".join(service.options["version"].value.split('.')[:2])
  def get_submessages(fields, names=[]):
      ret = []
      for field in fields:
          if field.message and isinstance(field.message, proto.Message) and not field.message.name in names:
              names.append(field.message.name)
              ret.append(field)
              ret += get_submessages(field.message.fields, names)
      return ret
  submessages = get_submessages(message.fields)
%>\
  ## ************************************************************** ##
  ## def print_doc
  ## ************************************************************** ##
<%def name="print_doc(doc, indent_level=0, indent='  ')">\
${(local_comments[0] and indent_level or 0)*indent}${local_comments[0]}\
      % for line in doc.text.splitlines():
${(indent_level)*indent}${local_comments[1]}${line.strip('\r\n')}
      % endfor
${(indent_level)*indent}${local_comments[2]}\
</%def>\
  ## ************************************************************** ##
  ## def message_class
  ## ************************************************************** ##
<%def name="message_class(message, submessages=None)">\
  % if message.doc:
${print_doc(message.doc, 0, INDENT)}
  % endif
  % if message.comment:
${INDENT}// ${message.comment}
  % endif
cls.${service.name}["${version}"].${message.name} = function(arr, parent)
{
  this.parent = parent || null;
  % for field in message.fields:
    % if field.doc:
${print_doc(field.doc, 1, INDENT)}
    % endif
    % if field.comment:
${INDENT}// ${field.comment}
    % endif
    % if field.q.name == "repeated":
${INDENT}var self = this;
${INDENT}this.${field.name} = (arr[${str(field.number - 1)}] || []).map(function(item)
${INDENT}{
${INDENT * 2}return new cls.${service.name}["${version}"].${field.typename()}(item, self);
${INDENT}});
    % elif field.message and isinstance(field.message, proto.Message):
${INDENT}this.${field.name} = arr[${str(field.number - 1)}] ? new cls.${service.name}["${version}"].${field.typename()}(arr[${str(field.number - 1)}], this) : null;
    % else:
      % if field.message and isinstance(field.message, proto.Enum):
${INDENT}// cls.${service.name}["${version}"].${message.name}.${field.message.name}
      % endif
${INDENT}this.${field.name} = arr[${str(field.number - 1)}];
    % endif
  % endfor
  this.toString = function() { return "[message ${message.name}]"; }
};
% if message.enums:
  % for enum in message.enums:
    % if enum.doc:
${print_doc(enum.doc, 0, INDENT)}
    % endif
cls.${service.name}["${version}"].${message.name}.${enum.name} =
{
    % for value in enum.values:
      % if value.doc:
${print_doc(value.doc, 1, INDENT)}
      % endif
${INDENT}${value.value}: "${value.name}",
    % endfor
};
  % endfor
% endif
</%def>\
  ## ************************************************************** ##
  ## template
  ## ************************************************************** ##
// Autogenerated by hob
window.cls || (window.cls = {});
cls.${service.name} || (cls.${service.name} = {});
cls.${service.name}["${version}"] || (cls.${service.name}["${version}"] = {});

${message_class(message, submessages=submessages)}
% for submsg in submessages:
${message_class(submsg.message, submessages=None)}
% endfor
