// ---------------------------------------------------
// automatically generated by SPECTRA GUI, do not edit
// ---------------------------------------------------

#ifndef spectra_input_h
#define spectra_input_h

#include <string>
#include <map>
#include <tuple>
#include <vector>
using namespace std;

// labels for parameters and data import
const string AccLabel = "Accelerator";
const string SrcLabel = "Light Source";
const string ConfigLabel = "Configurations";
const string SimplifiedLabel = "Simplified";
const string FMaterialLabel = "Filter Materials";
const string InputLabel = "Input";
const string OutputLabel = "Output";
const string OutFileLabel = "Output File";
const string Link2DLabel = "link2d";
const string TypeLabel = "Type";
const string ScanLabel = "Scan Parameter";
const string BundleScanlabel = "Bundle the output data";
const string OrgTypeLabel = "Original Type";
const string NumberLabel = "number";
const string IntegerLabel = "integer";
const string DataLabel = "data";
const string GridLabel = "grid";
const string BoolLabel = "boolean";
const string StringLabel = "string";
const string SelectionLabel = "selection";
const string ArrayLabel = "array";
const string TimeLabel = "time (fs)";
const string NormCurrLabel = "j (A/100%.E.S)";
const string BeamCurrLabel = "I (A)";
const string EdevLabel = "DE/E";
const string ZLabel = "z (m)";
const string BxLabel = "Bx (T)";
const string ByLabel = "By (T)";
const string GapLabel = "Gap (mm)";
const string EnergyLabel = "Energy (eV)";
const string TransmLabel = "Transmission";
const string PPBetaLabel = "betatron Functions";
const string PPFDlabel = "Field Distribution";
const string PP1stIntLabel = "1st Integral";
const string PP2ndIntLabel = "2nd Integral";
const string PPPhaseErrLabel = "Phase Error";
const string PPRedFlux = "Harmonic Intensity";
const string PPTransLabel = "Transmission Rate";
const string PPAbsLabel = "Absorption Rate";
const string ScanPrmItems = "4";
const string CalcStatusLabel = "Calculation Status: ";
const string Fin1ScanLabel = "Scan Process: ";
const string ScanOutLabel = "Output File: ";
const string ErrorLabel = "Error: ";
const string WarningLabel = "Warning: ";
const string DataDimLabel = "dimension";
const string DataTitlesLabel = "titles";
const string UnitsLabel = "units";
const string VariablesLabel = "variables";
const string DetailsLabel = "details";
const string RelateDataLabel = "Related Data";
const string ElapsedTimeLabel = "Elapsed Time (sec)";
const string CMDResultLabel = "CMD Result";
const string CMDModalFluxLabel = "Modal Flux";
const string CMDFieldLabel = "Modal Profile";
const string CMDIntensityLabel = "Modal Intensity";
const string CMDCompareIntLabel = "Flux Density Profile";
const string CMDCompareXLabel = "Wigner Func. (X,X')";
const string CMDCompareYLabel = "Wigner Func. (Y,Y')";
const string CMDErrorLabel = "numerical validity";
const string MaxOrderLabel = "maxorder";
const string WavelengthLabel = "wavelength";
const string SrcSizeLabel = "size";
const string OrderLabel = "order";
const string AmplitudeReLabel = "anm.re";
const string AmplitudeImLabel = "anm.im";
const string AmplitudeVReLabel = "anmv.re";
const string AmplitudeVImLabel = "anmv.im";
const string AmplitudeIndexReLabel = "anmidx.re";
const string AmplitudeIndexImLabel = "anmidx.im";
const string NormFactorLabel = "coefficient";
const string FluxCMDLabel = "photon flux";
const string MatrixErrLabel = "Matrix Error";
const string FluxErrLabel = "Flux Consistency";
const string WignerErrLabel = "Wigner Function Consistency";
const string FELCurrProfile = "Current Profile";
const string FELEtProfile = "E-t Profile";
const string FELCurrProfileR56 = "Current Profile with Dispersion";
const string FELEtProfileR56 = "E-t Profile with Dispersion";
const string FELBunchFactor = "Bunch Factor";
const string FELPulseEnergy = "Pulse Energy";
const string FELEfield = "On-Axis Field";
const string FELInstPower = "Inst. Power";
const string FELSpectrum = "Spectrum";
const string FELSecIdxLabel = "Section";
const string AccuracyLabel = "Numerical Accuracy";
const string PartConfLabel = "Particle Data Format";
const string SeedWavelLabel = "Wavelength (nm)";
const string SeedFluxLabel = "Intensity";
const string SeedPhaseLabel = "Phase (deg.)";
const string SProfLabel = "Spatial Profile";
const string AProfLabel = "Angular Profile (Source)";
const string BeamSizeLabel = "Beam Size";
const string OptAProfLabel = "Angular Profile (Optical Element)";
const string WignerLabel = "Wigner Function";
const string OptWignerLabel = "Wigner Function (Optical Element)";
const string WignerLabelx = "Wigner Function (x)";
const string WignerLabely = "Wigner Function (y)";
const string CSDLabel = "Cross Spectral Density";
const string CSDLabelx = "Cross Spectral Density (x)";
const string CSDLabely = "Cross Spectral Density (y)";
const string DegCohLabel = "Degree of Coherence";
const string DegCohLabelx = "Degree of Coherence (x)";
const string DegCohLabely = "Degree of Coherence (y)";
const string WigXLabel = "X";
const string WigXpLabel = "X'";
const string WigYLabel = "Y";
const string WigYpLabel = "Y'";
const string PrePLabel = "Pre-Processing";
const string UnitMeter = "m";
const string UnitMiliMeter = "mm";
const string UnitRad = "rad";
const string UnitMiliRad = "mrad";
const string UnitSec = "s";
const string UnitpSec = "ps";
const string UnitfSec = "fs";
const string UnitGeV = "GeV";
const string UnitMeV = "MeV";
const string UnitGamma = "gamma";

// labels for Accelerator types
const string RING = "Storage Ring";
const string LINAC = "Linear Accelerator";

// labels for ID types
const string LIN_UND = "Linear Undulator";
const string VERTICAL_UND = "Vertical Undulator";
const string HELICAL_UND = "Helical Undulator";
const string ELLIPTIC_UND = "Elliptic Undulator";
const string FIGURE8_UND = "Figure-8 Undulator";
const string VFIGURE8_UND = "Vertical Figure-8 Undulator";
const string MULTI_HARM_UND = "Multi-Harmonic Undulator";
const string BM = "Bending Magnet";
const string WIGGLER = "Wiggler";
const string EMPW = "EMPW";
const string WLEN_SHIFTER = "Wavelength Shifter";
const string FIELDMAP3D = "Field Mapping";
const string CUSTOM_PERIODIC = "Periodic: User Defined";
const string CUSTOM = "User Defined";

// labels for selections
const string AutomaticLabel = "Automatic";
const string DefaultLabel = "Default";
const string NoneLabel = "None";
const string GaussianLabel = "Gaussian";
const string CustomParticle = "Particle Distribution";
const string CustomCurrent = "Current Profile";
const string CustomEt = "E-t Profile";
const string CustomLabel = "Custom";
const string EntranceLabel = "Align at Entrance";
const string CenterLabel = "Align at Center";
const string ExitLabel = "Align at Exit";
const string BxOnlyLabel = "Bx";
const string ByOnlyLabel = "By";
const string BothLabel = "Both";
const string IdenticalLabel = "Identical";
const string ImpGapTableLabel = "Import Table";
const string SwapBxyLabel = "2nd: Swap Bx,y";
const string FlipBxLabel = "2nd: Flip Bx";
const string FlipByLabel = "2nd: Flip By";
const string AntiSymmLabel = "Antisymmetric";
const string SymmLabel = "Symmetric";
const string FixedSlitLabel = "Fixed";
const string NormSlitLabel = "Normalized";
const string GenFilterLabel = "Generic Filter";
const string BPFGaussianLabel = "BPF: Gaussian";
const string BPFBoxCarLabel = "BPF: Boxcar";
const string LinearLabel = "Linear";
const string LogLabel = "Logarithmic";
const string ArbPositionsLabel = "Export at Arbitrary Positions";
const string ObsPointDist = "Position";
const string ObsPointAngle = "Angle";
const string OutFormat = "Format";
const string JSONOnly = "JSON";
const string ASCIIOnly = "ASCII";
const string BothFormat = "Both";
const string BinaryOnly = "BINARY";
const string XOnly = "X";
const string YOnly = "Y";
const string FELPrebunchedLabel = "Prebunched FEL";
const string FELSeedLabel = "Seeded FEL";
const string FELSeedCustomLabel = "Seeded width Custom Pulse";
const string FELCPSeedLabel = "Seeded with Chirped Pulse";
const string FELDblSeedLabel = "Seeded with Double Pulse";
const string FELReuseLabel = "Reuse Bunch Factor";
const string PhaseErrZPole = "Pole Number";
const string PhaseErrZPos = "z (m)";
const string SingleLabel = "Single Slit";
const string DoubleLabel = "Double Slit";
const string ThinLensLabel = "Ideal Thin Lens";

// Menu items
namespace menu {
	const string far = "Far Field & Ideal Condition";
	const string near = "Near Field";
	const string cohrad = "Coherent Radiation";
	const string srcpoint = "Characterization at the Source Point";
	const string CMD = "Coherent Mode Decomposition";
	const string propagate = "Wavefront Propagation";
	const string fixed = "Fixed Point Calculation";
	const string energy = "Energy Dependence";
	const string spatial = "Spatial Dependence";
	const string Kvalue = "K Dependence";
	const string temporal = "Time Dependence";
	const string wigner = "Wigner Function";
	const string fdensa = "Angular Flux Density";
	const string pflux = "Partial Flux";
	const string tflux = "Total Flux";
	const string pdensa = "Angular Power Density";
	const string ppower = "Partial Power";
	const string pdensr = "Resolved Power Density";
	const string fdenss = "Spatial Flux Density";
	const string pdenss = "Spatial Power Density";
	const string spdens = "Surface Power Density";
	const string vpdens = "Volume Power Density";
	const string CMD2d = "CMD with the Wigner Function";
	const string CMDPP = "Modal Profile";
	const string CMDcheck = "Check Validity";
	const string efield = "Electric Field";
	const string camp = "Complex Amplitude";
	const string phasespace = "Phase-Space Distribution";
	const string sprof = "Spatial Profile";
	const string slitrect = "Rectangular Slit";
	const string slitcirc = "Circular Slit";
	const string along = "Along Axis";
	const string meshxy = "Mesh: x-y";
	const string meshrphi = "Mesh: r-&phi;";
	const string simpcalc = "Simplified Calculation";
	const string fluxfix = "Flux at a Fixed Energy";
	const string fluxpeak = "Peak Flux Curve";
	const string powercv = "Power";
	const string xzplane = "Planar Surface: x-z";
	const string yzplane = "Planar Surface: y-z";
	const string pipe = "Cylindrical Surface";
	const string XXpslice = "X-X' (Sliced)";
	const string XXpprj = "X-X' (Projected)";
	const string YYpslice = "Y-Y' (Sliced)";
	const string YYpprj = "Y-Y' (Projected)";
	const string XXpYYp = "X-X'-Y-Y'";
	const string tgtharm = "Target Harmonics";
	const string allharm = "All Harmonics";
	const string Wslice = "Sliced";
	const string WprjX = "Projected on X-X'";
	const string WprjY = "Projected on Y-Y'";
	const string Wrel = "Related Characteristics";
}

// Built-in Filter Materials
const map<string, tuple<double, vector<double>>> FilterMaterials {
	{"Air", tuple<double, vector<double>> (0.001184, {7, 0.755, 8, 0.232, 18, 0.013})},
	{"He", tuple<double, vector<double>> (0.000179, {2, 1})},
	{"Ar", tuple<double, vector<double>> (0.001784, {18, 1})},
	{"Be", tuple<double, vector<double>> (1.84, {4, 1})},
	{"C", tuple<double, vector<double>> (2.25, {6, 1})},
	{"Diamond", tuple<double, vector<double>> (3.52, {6, 1})},
	{"N2", tuple<double, vector<double>> (0.00125, {7, 1})},
	{"Al", tuple<double, vector<double>> (2.69, {13, 1})},
	{"Si", tuple<double, vector<double>> (2.34, {14, 1})},
	{"Ti", tuple<double, vector<double>> (4.506, {22, 1})},
	{"Cu", tuple<double, vector<double>> (8.93, {29, 1})},
	{"Mo", tuple<double, vector<double>> (10.28, {42, 1})},
	{"Rh", tuple<double, vector<double>> (12.41, {45, 1})},
	{"Pt", tuple<double, vector<double>> (21.45, {78, 1})},
	{"Au", tuple<double, vector<double>> (19.32, {79, 1})},
	{"Pb", tuple<double, vector<double>> (11.35, {82, 1})},
	{"Kapton", tuple<double, vector<double>> (1.42, {1, 0.026, 6, 0.69, 7, 0.073, 8, 0.21})}
};

// labels to force update for scan option
const vector<string>  UpdateScans {
	"&epsilon;<sub>1st</sub> (eV)", "&lambda;<sub>1st</sub> (nm)"
};

// Accelerator
enum AccIndex {
	eGeV_ = 0, imA_, aimA_, cirm_, bunches_, pulsepps_, bunchlength_, bunchcharge_,
		emitt_, coupl_, espread_, R56add_, minsize_, NumAccPrm,
	beta_ = 0, alpha_, eta_, etap_, xy_, xyp_, NumAccVec,
	zeroemitt_ = 0, zerosprd_, singlee_, NumAccBool,
	Acctype_ = 0, bunchtype_, injectionebm_, NumAccSel,
	bunchdata_ = 0, NumAccStr,
	currdata_ = 0, Etdata_, NumAccData
};

const map<string, tuple<int, string>> Acc {
	{"Energy (GeV)", tuple<int, string> (eGeV_, "number")},
	{"Current (mA)", tuple<int, string> (imA_, "number")},
	{"Avg. Current (mA)", tuple<int, string> (aimA_, "number")},
	{"Circumference (m)", tuple<int, string> (cirm_, "number")},
	{"Bunches", tuple<int, string> (bunches_, "number")},
	{"Pulses/sec", tuple<int, string> (pulsepps_, "number")},
	{"&sigma;<sub>z</sub> (mm)", tuple<int, string> (bunchlength_, "number")},
	{"Bunch Charge (nC)", tuple<int, string> (bunchcharge_, "number")},
	{"Nat. Emittance (m.rad)", tuple<int, string> (emitt_, "number")},
	{"Coupling Constant", tuple<int, string> (coupl_, "number")},
	{"Energy Spread", tuple<int, string> (espread_, "number")},
	{"Additional R<sub>56</sub> (m)", tuple<int, string> (R56add_, "number")},
	{"Beam Size Lower Limit (m)", tuple<int, string> (minsize_, "number")},
	{"&beta;<sub>x,y</sub> (m)", tuple<int, string> (beta_, "array")},
	{"&alpha;<sub>x,y</sub>", tuple<int, string> (alpha_, "array")},
	{"&eta;<sub>x,y</sub> (m)", tuple<int, string> (eta_, "array")},
	{"&eta;'<sub>x,y</sub>", tuple<int, string> (etap_, "array")},
	{"x,y (mm)", tuple<int, string> (xy_, "array")},
	{"x',y' (mrad)", tuple<int, string> (xyp_, "array")},
	{"Zero Emittance", tuple<int, string> (zeroemitt_, "boolean")},
	{"Zero Energy Spread", tuple<int, string> (zerosprd_, "boolean")},
	{"Single Electron", tuple<int, string> (singlee_, "boolean")},
	{"Type", tuple<int, string> (Acctype_, "selection")},
	{"Bunch Profile", tuple<int, string> (bunchtype_, "selection")},
	{"Injection Condition", tuple<int, string> (injectionebm_, "selection")},
	{"Particle Distribution", tuple<int, string> (bunchdata_, "string")},
	{"Current Profile", tuple<int, string> (currdata_, "data")},
	{"E-t Profile", tuple<int, string> (Etdata_, "data")}
};

const map<string, tuple<int, string>> AccSimple {
	{"eGeV", tuple<int, string> (eGeV_, "number")},
	{"imA", tuple<int, string> (imA_, "number")},
	{"aimA", tuple<int, string> (aimA_, "number")},
	{"cirm", tuple<int, string> (cirm_, "number")},
	{"bunches", tuple<int, string> (bunches_, "number")},
	{"pulsepps", tuple<int, string> (pulsepps_, "number")},
	{"bunchlength", tuple<int, string> (bunchlength_, "number")},
	{"bunchcharge", tuple<int, string> (bunchcharge_, "number")},
	{"emitt", tuple<int, string> (emitt_, "number")},
	{"coupl", tuple<int, string> (coupl_, "number")},
	{"espread", tuple<int, string> (espread_, "number")},
	{"R56add", tuple<int, string> (R56add_, "number")},
	{"minsize", tuple<int, string> (minsize_, "number")},
	{"beta", tuple<int, string> (beta_, "array")},
	{"alpha", tuple<int, string> (alpha_, "array")},
	{"eta", tuple<int, string> (eta_, "array")},
	{"etap", tuple<int, string> (etap_, "array")},
	{"xy", tuple<int, string> (xy_, "array")},
	{"xyp", tuple<int, string> (xyp_, "array")},
	{"zeroemitt", tuple<int, string> (zeroemitt_, "boolean")},
	{"zerosprd", tuple<int, string> (zerosprd_, "boolean")},
	{"singlee", tuple<int, string> (singlee_, "boolean")},
	{"Acctype", tuple<int, string> (Acctype_, "selection")},
	{"bunchtype", tuple<int, string> (bunchtype_, "selection")},
	{"injectionebm", tuple<int, string> (injectionebm_, "selection")},
	{"bunchdata", tuple<int, string> (bunchdata_, "string")},
	{"currdata", tuple<int, string> (currdata_, "data")},
	{"Etdata", tuple<int, string> (Etdata_, "data")}
};

const vector<double> DefAccPrm {
	8, 100, 100, 1435.95, 203, 60, 3.9, 0.1,
	2.4e-9, 0.002, 0.0011, 0, 1e-12
};

const vector<vector<double>> DefAccVec {
	{31.2, 5}, {0, 0}, {0.146, 0}, {0, 0}, {0, 0}, {0, 0}
};

const vector<bool> DefAccBool {
	false, false, false
};

const vector<string> DefAccSel {
	"Storage Ring", "Gaussian", "Automatic"
};

const vector<string> DefAccStr {
	""
};

// Light Source
enum SrcIndex {
	gap_ = 0, b_, bmain_, subpoleb_, lu_, devlength_, periods_, phase_,
		K_, e1st_, lambda1_, radius_, bendlength_, fringelen_, mplength_, subpolel_,
		bminterv_, csrorg_, br_, seed_, fsigma_, psigma_, segments_, hsegments_,
		interval_, phi0_, mdist_, NumSrcPrm,
	bxy_ = 0, Kxy0_, Kxy_, geofactor_, boffset_, ltaper_, qtaper_, xysigma_,
		phi12_, NumSrcVec,
	apple_ = 0, endmag_, fielderr_, phaseerr_, bmtandem_, perlattice_, NumSrcBool,
	Srctype_ = 0, gaplink_, field_str_, natfocus_, segment_type_, NumSrcSel,
	fmap_ = 0, NumSrcStr,
	fvsz_ = 0, fvsz1per_, multiharm_, gaptbl_, NumSrcData
};

const map<string, tuple<int, string>> Src {
	{"Gap (mm)", tuple<int, string> (gap_, "number")},
	{"B (T)", tuple<int, string> (b_, "number")},
	{"Main Field (T)", tuple<int, string> (bmain_, "number")},
	{"Sub Field (T)", tuple<int, string> (subpoleb_, "number")},
	{"&lambda;<sub>u</sub> (mm)", tuple<int, string> (lu_, "number")},
	{"Device Length (m)", tuple<int, string> (devlength_, "number")},
	{"# of Reg. Periods", tuple<int, string> (periods_, "number")},
	{"Phase Shift (mm)", tuple<int, string> (phase_, "number")},
	{"K value", tuple<int, string> (K_, "number")},
	{"&epsilon;<sub>1st</sub> (eV)", tuple<int, string> (e1st_, "number")},
	{"&lambda;<sub>1st</sub> (nm)", tuple<int, string> (lambda1_, "number")},
	{"&rho; (m)", tuple<int, string> (radius_, "number")},
	{"BM Length (m)", tuple<int, string> (bendlength_, "number")},
	{"BM Fringe Length (m)", tuple<int, string> (fringelen_, "number")},
	{"Main Length (m)", tuple<int, string> (mplength_, "number")},
	{"Sub Length (m)", tuple<int, string> (subpolel_, "number")},
	{"BM Interval (m)", tuple<int, string> (bminterv_, "number")},
	{"Origin for CSR (m)", tuple<int, string> (csrorg_, "number")},
	{"B<sub>r</sub> (T)", tuple<int, string> (br_, "number")},
	{"Random Number Seed", tuple<int, string> (seed_, "number")},
	{"&sigma;<sub>B</sub> (%)", tuple<int, string> (fsigma_, "number")},
	{"&sigma;<sub>&phi;</sub> (deg.)", tuple<int, string> (psigma_, "number")},
	{"Number of Segments", tuple<int, string> (segments_, "number")},
	{"Half Number of Segments", tuple<int, string> (hsegments_, "number")},
	{"Segment Interval (m)", tuple<int, string> (interval_, "number")},
	{"&Delta;&phi; (&pi;)", tuple<int, string> (phi0_, "number")},
	{"Matching Distance (m)", tuple<int, string> (mdist_, "number")},
	{"B<sub>x,y</sub> (T)", tuple<int, string> (bxy_, "array")},
	{"K<sub>0x,0y</sub>", tuple<int, string> (Kxy0_, "array")},
	{"K<sub>x,y</sub>", tuple<int, string> (Kxy_, "array")},
	{"Geometrical Factor (x,y)", tuple<int, string> (geofactor_, "array")},
	{"Offset x,y (T)", tuple<int, string> (boffset_, "array")},
	{"Lin. Taper x,y (/m)", tuple<int, string> (ltaper_, "array")},
	{"Quad. Taper x,y (/m<sup>2</sup>)", tuple<int, string> (qtaper_, "array")},
	{"&sigma;<sub>x,y</sub> (mm);", tuple<int, string> (xysigma_, "array")},
	{"&Delta;&phi;<sub>1,2</sub> (&pi;)", tuple<int, string> (phi12_, "array")},
	{"APPLE Configuration", tuple<int, string> (apple_, "boolean")},
	{"End Correction Magnet", tuple<int, string> (endmag_, "boolean")},
	{"Field Offset & Taper", tuple<int, string> (fielderr_, "boolean")},
	{"Add Phase Error", tuple<int, string> (phaseerr_, "boolean")},
	{"Tandem Arrangement", tuple<int, string> (bmtandem_, "boolean")},
	{"Periodic &beta; Function", tuple<int, string> (perlattice_, "boolean")},
	{"Type", tuple<int, string> (Srctype_, "selection")},
	{"Gap-Field Relation", tuple<int, string> (gaplink_, "selection")},
	{"Field Structure", tuple<int, string> (field_str_, "selection")},
	{"Natural Focusing", tuple<int, string> (natfocus_, "selection")},
	{"Segmentation", tuple<int, string> (segment_type_, "selection")},
	{"Field Mapping Data", tuple<int, string> (fmap_, "string")},
	{"Field Profile", tuple<int, string> (fvsz_, "data")},
	{"Field Profile (1 Period)", tuple<int, string> (fvsz1per_, "data")},
	{"Harmonic Component", tuple<int, string> (multiharm_, "grid")},
	{"Gap vs. Field", tuple<int, string> (gaptbl_, "data")}
};

const map<string, tuple<int, string>> SrcSimple {
	{"gap", tuple<int, string> (gap_, "number")},
	{"b", tuple<int, string> (b_, "number")},
	{"bmain", tuple<int, string> (bmain_, "number")},
	{"subpoleb", tuple<int, string> (subpoleb_, "number")},
	{"lu", tuple<int, string> (lu_, "number")},
	{"devlength", tuple<int, string> (devlength_, "number")},
	{"periods", tuple<int, string> (periods_, "number")},
	{"phase", tuple<int, string> (phase_, "number")},
	{"K", tuple<int, string> (K_, "number")},
	{"e1st", tuple<int, string> (e1st_, "number")},
	{"lambda1", tuple<int, string> (lambda1_, "number")},
	{"radius", tuple<int, string> (radius_, "number")},
	{"bendlength", tuple<int, string> (bendlength_, "number")},
	{"fringelen", tuple<int, string> (fringelen_, "number")},
	{"mplength", tuple<int, string> (mplength_, "number")},
	{"subpolel", tuple<int, string> (subpolel_, "number")},
	{"bminterv", tuple<int, string> (bminterv_, "number")},
	{"csrorg", tuple<int, string> (csrorg_, "number")},
	{"br", tuple<int, string> (br_, "number")},
	{"seed", tuple<int, string> (seed_, "number")},
	{"fsigma", tuple<int, string> (fsigma_, "number")},
	{"psigma", tuple<int, string> (psigma_, "number")},
	{"segments", tuple<int, string> (segments_, "number")},
	{"hsegments", tuple<int, string> (hsegments_, "number")},
	{"interval", tuple<int, string> (interval_, "number")},
	{"phi0", tuple<int, string> (phi0_, "number")},
	{"mdist", tuple<int, string> (mdist_, "number")},
	{"bxy", tuple<int, string> (bxy_, "array")},
	{"Kxy0", tuple<int, string> (Kxy0_, "array")},
	{"Kxy", tuple<int, string> (Kxy_, "array")},
	{"geofactor", tuple<int, string> (geofactor_, "array")},
	{"boffset", tuple<int, string> (boffset_, "array")},
	{"ltaper", tuple<int, string> (ltaper_, "array")},
	{"qtaper", tuple<int, string> (qtaper_, "array")},
	{"xysigma", tuple<int, string> (xysigma_, "array")},
	{"phi12", tuple<int, string> (phi12_, "array")},
	{"apple", tuple<int, string> (apple_, "boolean")},
	{"endmag", tuple<int, string> (endmag_, "boolean")},
	{"fielderr", tuple<int, string> (fielderr_, "boolean")},
	{"phaseerr", tuple<int, string> (phaseerr_, "boolean")},
	{"bmtandem", tuple<int, string> (bmtandem_, "boolean")},
	{"perlattice", tuple<int, string> (perlattice_, "boolean")},
	{"Srctype", tuple<int, string> (Srctype_, "selection")},
	{"gaplink", tuple<int, string> (gaplink_, "selection")},
	{"field_str", tuple<int, string> (field_str_, "selection")},
	{"natfocus", tuple<int, string> (natfocus_, "selection")},
	{"segment_type", tuple<int, string> (segment_type_, "selection")},
	{"fmap", tuple<int, string> (fmap_, "string")},
	{"fvsz", tuple<int, string> (fvsz_, "data")},
	{"fvsz1per", tuple<int, string> (fvsz1per_, "data")},
	{"multiharm", tuple<int, string> (multiharm_, "grid")},
	{"gaptbl", tuple<int, string> (gaptbl_, "data")}
};

const vector<double> DefSrcPrm {
	8, 0.679498, 1, 1, 32, 4.564, 10, 0,
	1, 12000, 1, 39.2718, 2.8, 0.05, 0.1, 0.05,
	5, 0, 1.2, 1, 0.5, 5, 2, 1,
	5, 1, 5
};

const vector<vector<double>> DefSrcVec {
	{0.5, 0.5}, {0.6, 1}, {1, 1}, {0.6, 0.9}, {0, 0}, {0, 0}, {0, 0}, {0.001, 0.001},
	{0.5, 1.5}
};

const vector<bool> DefSrcBool {
	false, true, false, false, false, false
};

const vector<string> DefSrcSel {
	"Linear Undulator", "None", "Antisymmetric", "None",
	"None"
};

const vector<string> DefSrcStr {
	""
};

// Configurations
enum ConfIndex {
	slit_dist_ = 0, hfix_, hmax_, detune_, de_, epitch_, emesh_, nefix_,
		efix_, spdxfix_, spdyfix_, spdrfix_, Qnorm_, Phinorm_, Qgl_, Phiinc_,
		pplimit_, zmesh_, grlevel_, xmesh_, wdxmesh_, ymesh_, wdymesh_, rphimesh_,
		qphimesh_, phimesh_, dmesh_, optpos_, aptx_, aptdistx_, apty_, aptdisty_,
		softedge_, diflim_, anglelevel_, memsize_, foclenx_, focleny_, kmesh_, tmesh_,
		horizacc_, Xfix_, Yfix_, Xpfix_, Ypfix_, Xmesh_, Xpmesh_, Ymesh_,
		Ypmesh_, bpfcenter_, bpfwidth_, bpfsigma_, bpfmaxeff_, xsmooth_, smoothwin_, acclevel_,
		fieldrangex_, fieldrangey_, fieldgridx_, fieldgridy_, HGorderx_, HGordery_, maxHGorderx_, maxHGordery_,
		maxmode_, fcutoff_, cutoff_, pulseE_, wavelen_, pulselen_, tlpulselen_, srcsize_,
		waistpos_, timing_, gdd_, tod_, radstep_, particles_, edevstep_, R56_,
		NumConfPrm,
	hrange_ = 0, erange_, xyfix_, qxyfix_, slitpos_, qslitpos_, nslitapt_, slitapt_,
		qslitapt_, slitr_, slitq_, zrange_, xrange_, qxrange_, wnxrange_, wdxrange_,
		wndxrange_, yrange_, qyrange_, wnyrange_, wdyrange_, wndyrange_, rrange_, qrange_,
		phirange_, drange_, krange_, ckrange_, trange_, gtacc_, Xrange_, Xprange_,
		Yrange_, Yprange_, fieldrangexy_, fieldgridxy_, HGorderxy_, maxHGorderxy_, pulseE_d_, wavelen_d_,
		tlpulselen_d_, srcsize_d_, waistpos_d_, timing_d_, gdd_d_, tod_d_, svstep_, eproi_,
		NumConfVec,
	autoe_ = 0, autot_, aprofile_, wigner_, csd_, degcoh_, normenergy_, powlimit_,
		optDx_, fouriep_, wiggapprox_, esmooth_, CMD_, GSModel_, CMDint_, CMDcmp_,
		CMDcmpint_, exportInt_, R56Bunch_, exportEt_, NumConfBool,
	gridspec_ = 0, optics_, filter_, dstep_, defobs_, estep_, aperture_, accuracy_,
		GSModelXY_, CMDfld_, fel_, NumConfSel,
	Conftype_ = 0, NumConfStr,
	fmateri_ = 0, fcustom_, amateri_, depthdata_, seedspec_, NumConfData
};

const map<string, tuple<int, string>> Conf {
	{"Distance from the Source (m)", tuple<int, string> (slit_dist_, "number")},
	{"Target Harmonic", tuple<int, string> (hfix_, "number")},
	{"Maximum Harmonic", tuple<int, string> (hmax_, "number")},
	{"Detuning", tuple<int, string> (detune_, "number")},
	{"Energy Pitch (eV)", tuple<int, string> (de_, "number")},
	{"Energy Pitch for Integration (eV)", tuple<int, string> (epitch_, "number")},
	{"Points (Energy)", tuple<int, string> (emesh_, "number")},
	{"Normalized Energy", tuple<int, string> (nefix_, "number")},
	{"Target Energy (eV)", tuple<int, string> (efix_, "number")},
	{"Surface Pos. x (mm)", tuple<int, string> (spdxfix_, "number")},
	{"Surface Pos. y (mm)", tuple<int, string> (spdyfix_, "number")},
	{"Surface Radius (mm)", tuple<int, string> (spdrfix_, "number")},
	{"&Theta; (deg.)", tuple<int, string> (Qnorm_, "number")},
	{"&Phi; (deg.)", tuple<int, string> (Phinorm_, "number")},
	{"Glancing Angle (deg.)", tuple<int, string> (Qgl_, "number")},
	{"Azimuth of Incidence (deg.)", tuple<int, string> (Phiinc_, "number")},
	{"Power Upper Limit (kW)", tuple<int, string> (pplimit_, "number")},
	{"Points (z)", tuple<int, string> (zmesh_, "number")},
	{"Finer Spatial Grid", tuple<int, string> (grlevel_, "number")},
	{"Points (x)", tuple<int, string> (xmesh_, "number")},
	{"Points (&delta;x)", tuple<int, string> (wdxmesh_, "number")},
	{"Points (y)", tuple<int, string> (ymesh_, "number")},
	{"Points (&delta;y)", tuple<int, string> (wdymesh_, "number")},
	{"Points (r)", tuple<int, string> (rphimesh_, "number")},
	{"Points (&theta;)", tuple<int, string> (qphimesh_, "number")},
	{"Points (&phi;)", tuple<int, string> (phimesh_, "number")},
	{"Points (Depth)", tuple<int, string> (dmesh_, "number")},
	{"Position (m)", tuple<int, string> (optpos_, "number")},
	{"Aperture x (mm)", tuple<int, string> (aptx_, "number")},
	{"Slit Distance x  (mm)", tuple<int, string> (aptdistx_, "number")},
	{"Aperture y (mm)", tuple<int, string> (apty_, "number")},
	{"Slit Distance y  (mm)", tuple<int, string> (aptdisty_, "number")},
	{"Soft Edge Fringe Size (mm)", tuple<int, string> (softedge_, "number")},
	{"Limit of Diffraction Effect", tuple<int, string> (diflim_, "number")},
	{"Larger Angular Range", tuple<int, string> (anglelevel_, "number")},
	{"Required Memory (MB) ~", tuple<int, string> (memsize_, "number")},
	{"Focal Length x (m)", tuple<int, string> (foclenx_, "number")},
	{"Focal Length y (m)", tuple<int, string> (focleny_, "number")},
	{"Points (K)", tuple<int, string> (kmesh_, "number")},
	{"Points (Temporal)", tuple<int, string> (tmesh_, "number")},
	{"X' Acceptance (mrad)", tuple<int, string> (horizacc_, "number")},
	{"Slice X (mm)", tuple<int, string> (Xfix_, "number")},
	{"Slice Y (mm)", tuple<int, string> (Yfix_, "number")},
	{"Slice X' (mrad)", tuple<int, string> (Xpfix_, "number")},
	{"Slice Y' (mrad)", tuple<int, string> (Ypfix_, "number")},
	{"Points (X)", tuple<int, string> (Xmesh_, "number")},
	{"Points (X')", tuple<int, string> (Xpmesh_, "number")},
	{"Points (Y)", tuple<int, string> (Ymesh_, "number")},
	{"Points (Y')", tuple<int, string> (Ypmesh_, "number")},
	{"Central Energy (eV)", tuple<int, string> (bpfcenter_, "number")},
	{"Width (eV)", tuple<int, string> (bpfwidth_, "number")},
	{"Width (&sigma;, eV)", tuple<int, string> (bpfsigma_, "number")},
	{"Max. Trans. Rate", tuple<int, string> (bpfmaxeff_, "number")},
	{"Level of Smoothing Along X", tuple<int, string> (xsmooth_, "number")},
	{"Smoothing Window (%)", tuple<int, string> (smoothwin_, "number")},
	{"Accuracy Level", tuple<int, string> (acclevel_, "number")},
	{"Range: X (mm)", tuple<int, string> (fieldrangex_, "number")},
	{"Range: Y (mm)", tuple<int, string> (fieldrangey_, "number")},
	{"Step: X (mm)", tuple<int, string> (fieldgridx_, "number")},
	{"Step: Y (mm)", tuple<int, string> (fieldgridy_, "number")},
	{"HG Order Limit (X)", tuple<int, string> (HGorderx_, "number")},
	{"HG Order Limit (Y)", tuple<int, string> (HGordery_, "number")},
	{"Max. HG Order (X)", tuple<int, string> (maxHGorderx_, "number")},
	{"Max. HG Order (Y)", tuple<int, string> (maxHGordery_, "number")},
	{"Maximum CMD Order", tuple<int, string> (maxmode_, "number")},
	{"Flux Cutoff", tuple<int, string> (fcutoff_, "number")},
	{"Amplitude Cutoff", tuple<int, string> (cutoff_, "number")},
	{"Pulse Energy (mJ)", tuple<int, string> (pulseE_, "number")},
	{"Wavelength (nm)", tuple<int, string> (wavelen_, "number")},
	{"Pulse Length (FWHM, fs)", tuple<int, string> (pulselen_, "number")},
	{"TL. Pulse Length (FWHM, fs)", tuple<int, string> (tlpulselen_, "number")},
	{"Source Size (FWHM, mm)", tuple<int, string> (srcsize_, "number")},
	{"Waist Position (m)", tuple<int, string> (waistpos_, "number")},
	{"Timing (fs)", tuple<int, string> (timing_, "number")},
	{"GDD (fs<sup>2</sup>)", tuple<int, string> (gdd_, "number")},
	{"TOD (fs<sup>3</sup>)", tuple<int, string> (tod_, "number")},
	{"Substeps for Radiation", tuple<int, string> (radstep_, "number")},
	{"Number of Particles", tuple<int, string> (particles_, "number")},
	{"e- Energy Interval", tuple<int, string> (edevstep_, "number")},
	{"R<sub>56</sub> (m)", tuple<int, string> (R56_, "number")},
	{"Harmonic Range", tuple<int, string> (hrange_, "array")},
	{"Energy Range (eV)", tuple<int, string> (erange_, "array")},
	{"Position x,y (mm)", tuple<int, string> (xyfix_, "array")},
	{"Angle &theta;<sub>x,y</sub> (mrad)", tuple<int, string> (qxyfix_, "array")},
	{"Slit Pos.: x,y (mm)", tuple<int, string> (slitpos_, "array")},
	{"Slit Pos.: &theta;<sub>x,y</sub> (mrad)", tuple<int, string> (qslitpos_, "array")},
	{"&Delta;/&Sigma;<sub>s</sub>: x,y", tuple<int, string> (nslitapt_, "array")},
	{"&Delta;x,&Delta;y (mm)", tuple<int, string> (slitapt_, "array")},
	{"&Delta;&theta;<sub>x,y</sub> (mrad)", tuple<int, string> (qslitapt_, "array")},
	{"Slit r<sub>1,2</sub> (mm)", tuple<int, string> (slitr_, "array")},
	{"Slit &theta;<sub>1,2</sub> (mrad)", tuple<int, string> (slitq_, "array")},
	{"z range (m)", tuple<int, string> (zrange_, "array")},
	{"x Range (mm)", tuple<int, string> (xrange_, "array")},
	{"&theta;<sub>x</sub> Range (mrad)", tuple<int, string> (qxrange_, "array")},
	{"x Range/&Sigma;", tuple<int, string> (wnxrange_, "array")},
	{"&delta;x Range (mm)", tuple<int, string> (wdxrange_, "array")},
	{"&delta;x Range/&Sigma;", tuple<int, string> (wndxrange_, "array")},
	{"y Range (mm)", tuple<int, string> (yrange_, "array")},
	{"&theta;<sub>y</sub> Range (mrad)", tuple<int, string> (qyrange_, "array")},
	{"y Range/&Sigma;", tuple<int, string> (wnyrange_, "array")},
	{"&delta;y Range (mm)", tuple<int, string> (wdyrange_, "array")},
	{"&delta;y Range/&Sigma;", tuple<int, string> (wndyrange_, "array")},
	{"r Range (mm)", tuple<int, string> (rrange_, "array")},
	{"&theta; Range (mrad)", tuple<int, string> (qrange_, "array")},
	{"&phi; Range (deg.)", tuple<int, string> (phirange_, "array")},
	{"Depth Range (mm)", tuple<int, string> (drange_, "array")},
	{"K Range", tuple<int, string> (krange_, "array")},
	{"K<sub>&perp;</sub> Range", tuple<int, string> (ckrange_, "array")},
	{"Temporal Range (fs)", tuple<int, string> (trange_, "array")},
	{"&gamma;&Delta;&theta;<sub>x,y</sub>", tuple<int, string> (gtacc_, "array")},
	{"X Range (mm)", tuple<int, string> (Xrange_, "array")},
	{"X' Range (mrad)", tuple<int, string> (Xprange_, "array")},
	{"Y Range (mm)", tuple<int, string> (Yrange_, "array")},
	{"Y' Range (mrad)", tuple<int, string> (Yprange_, "array")},
	{"Range: X,Y (mm)", tuple<int, string> (fieldrangexy_, "array")},
	{"Step: X,Y (mm)", tuple<int, string> (fieldgridxy_, "array")},
	{"HG Order Limit (X,Y)", tuple<int, string> (HGorderxy_, "array")},
	{"Max. HG Order (X,Y)", tuple<int, string> (maxHGorderxy_, "array")},
	{"Pulse Energy: 1,2 (mJ)", tuple<int, string> (pulseE_d_, "array")},
	{"Wavelength: 1,2 (nm)", tuple<int, string> (wavelen_d_, "array")},
	{"TL. Pulse Length: 1,2 (FWHM, fs)", tuple<int, string> (tlpulselen_d_, "array")},
	{"Source Size: 1,2 (FWHM, mm)", tuple<int, string> (srcsize_d_, "array")},
	{"Waist Position: 1,2 (m)", tuple<int, string> (waistpos_d_, "array")},
	{"Timing: 1,2 (fs)", tuple<int, string> (timing_d_, "array")},
	{"GDD: 1,2 (fs<sup>2</sup>)", tuple<int, string> (gdd_d_, "array")},
	{"TOD: 1,2 (fs<sup>3</sup>)", tuple<int, string> (tod_d_, "array")},
	{"Step: Initial, Interval (m)", tuple<int, string> (svstep_, "array")},
	{"Photon Energy ROI (eV)", tuple<int, string> (eproi_, "array")},
	{"Auto Config. for Energy Range", tuple<int, string> (autoe_, "boolean")},
	{"Auto Config. for Transverse Range", tuple<int, string> (autot_, "boolean")},
	{"Angular Profile", tuple<int, string> (aprofile_, "boolean")},
	{"Wigner Function", tuple<int, string> (wigner_, "boolean")},
	{"Cross Spectral Density", tuple<int, string> (csd_, "boolean")},
	{"Degree of Coherence", tuple<int, string> (degcoh_, "boolean")},
	{"Normalize Photon Energy", tuple<int, string> (normenergy_, "boolean")},
	{"Set Upper Limit on Power", tuple<int, string> (powlimit_, "boolean")},
	{"Optimize &Delta;X' for Computation", tuple<int, string> (optDx_, "boolean")},
	{"Observation in the Fourier Plane", tuple<int, string> (fouriep_, "boolean")},
	{"Wiggler Approximation", tuple<int, string> (wiggapprox_, "boolean")},
	{"Spectral Smoothing", tuple<int, string> (esmooth_, "boolean")},
	{"Perform CMD?", tuple<int, string> (CMD_, "boolean")},
	{"Apply GS Model", tuple<int, string> (GSModel_, "boolean")},
	{"Export Intensity Profile", tuple<int, string> (CMDint_, "boolean")},
	{"Compare Wigner Function", tuple<int, string> (CMDcmp_, "boolean")},
	{"Compare Intensity Profile", tuple<int, string> (CMDcmpint_, "boolean")},
	{"Export Intermediate Data", tuple<int, string> (exportInt_, "boolean")},
	{"Bunch with Dispersion", tuple<int, string> (R56Bunch_, "boolean")},
	{"E-t Data", tuple<int, string> (exportEt_, "boolean")},
	{"Transverse Grid", tuple<int, string> (gridspec_, "selection")},
	{"Optical Element", tuple<int, string> (optics_, "selection")},
	{"Filtering", tuple<int, string> (filter_, "selection")},
	{"Depth Step", tuple<int, string> (dstep_, "selection")},
	{"Define Obs. Point in", tuple<int, string> (defobs_, "selection")},
	{"Energy Step", tuple<int, string> (estep_, "selection")},
	{"Slit Aperture Size", tuple<int, string> (aperture_, "selection")},
	{"Accuracy", tuple<int, string> (accuracy_, "selection")},
	{"GS Model X/Y", tuple<int, string> (GSModelXY_, "selection")},
	{"Export Field Profile", tuple<int, string> (CMDfld_, "selection")},
	{"FEL Mode", tuple<int, string> (fel_, "selection")},
	{"Type", tuple<int, string> (Conftype_, "string")},
	{"Filters", tuple<int, string> (fmateri_, "grid")},
	{"Custom Filter", tuple<int, string> (fcustom_, "data")},
	{"Absorbers", tuple<int, string> (amateri_, "grid")},
	{"Depth-Position Data", tuple<int, string> (depthdata_, "data")},
	{"Seed Spectrum", tuple<int, string> (seedspec_, "data")}
};

const map<string, tuple<int, string>> ConfSimple {
	{"slit_dist", tuple<int, string> (slit_dist_, "number")},
	{"hfix", tuple<int, string> (hfix_, "number")},
	{"hmax", tuple<int, string> (hmax_, "number")},
	{"detune", tuple<int, string> (detune_, "number")},
	{"de", tuple<int, string> (de_, "number")},
	{"epitch", tuple<int, string> (epitch_, "number")},
	{"emesh", tuple<int, string> (emesh_, "number")},
	{"nefix", tuple<int, string> (nefix_, "number")},
	{"efix", tuple<int, string> (efix_, "number")},
	{"spdxfix", tuple<int, string> (spdxfix_, "number")},
	{"spdyfix", tuple<int, string> (spdyfix_, "number")},
	{"spdrfix", tuple<int, string> (spdrfix_, "number")},
	{"Qnorm", tuple<int, string> (Qnorm_, "number")},
	{"Phinorm", tuple<int, string> (Phinorm_, "number")},
	{"Qgl", tuple<int, string> (Qgl_, "number")},
	{"Phiinc", tuple<int, string> (Phiinc_, "number")},
	{"pplimit", tuple<int, string> (pplimit_, "number")},
	{"zmesh", tuple<int, string> (zmesh_, "number")},
	{"grlevel", tuple<int, string> (grlevel_, "number")},
	{"xmesh", tuple<int, string> (xmesh_, "number")},
	{"wdxmesh", tuple<int, string> (wdxmesh_, "number")},
	{"ymesh", tuple<int, string> (ymesh_, "number")},
	{"wdymesh", tuple<int, string> (wdymesh_, "number")},
	{"rphimesh", tuple<int, string> (rphimesh_, "number")},
	{"qphimesh", tuple<int, string> (qphimesh_, "number")},
	{"phimesh", tuple<int, string> (phimesh_, "number")},
	{"dmesh", tuple<int, string> (dmesh_, "number")},
	{"optpos", tuple<int, string> (optpos_, "number")},
	{"aptx", tuple<int, string> (aptx_, "number")},
	{"aptdistx", tuple<int, string> (aptdistx_, "number")},
	{"apty", tuple<int, string> (apty_, "number")},
	{"aptdisty", tuple<int, string> (aptdisty_, "number")},
	{"softedge", tuple<int, string> (softedge_, "number")},
	{"diflim", tuple<int, string> (diflim_, "number")},
	{"anglelevel", tuple<int, string> (anglelevel_, "number")},
	{"memsize", tuple<int, string> (memsize_, "number")},
	{"foclenx", tuple<int, string> (foclenx_, "number")},
	{"focleny", tuple<int, string> (focleny_, "number")},
	{"kmesh", tuple<int, string> (kmesh_, "number")},
	{"tmesh", tuple<int, string> (tmesh_, "number")},
	{"horizacc", tuple<int, string> (horizacc_, "number")},
	{"Xfix", tuple<int, string> (Xfix_, "number")},
	{"Yfix", tuple<int, string> (Yfix_, "number")},
	{"Xpfix", tuple<int, string> (Xpfix_, "number")},
	{"Ypfix", tuple<int, string> (Ypfix_, "number")},
	{"Xmesh", tuple<int, string> (Xmesh_, "number")},
	{"Xpmesh", tuple<int, string> (Xpmesh_, "number")},
	{"Ymesh", tuple<int, string> (Ymesh_, "number")},
	{"Ypmesh", tuple<int, string> (Ypmesh_, "number")},
	{"bpfcenter", tuple<int, string> (bpfcenter_, "number")},
	{"bpfwidth", tuple<int, string> (bpfwidth_, "number")},
	{"bpfsigma", tuple<int, string> (bpfsigma_, "number")},
	{"bpfmaxeff", tuple<int, string> (bpfmaxeff_, "number")},
	{"xsmooth", tuple<int, string> (xsmooth_, "number")},
	{"smoothwin", tuple<int, string> (smoothwin_, "number")},
	{"acclevel", tuple<int, string> (acclevel_, "number")},
	{"fieldrangex", tuple<int, string> (fieldrangex_, "number")},
	{"fieldrangey", tuple<int, string> (fieldrangey_, "number")},
	{"fieldgridx", tuple<int, string> (fieldgridx_, "number")},
	{"fieldgridy", tuple<int, string> (fieldgridy_, "number")},
	{"HGorderx", tuple<int, string> (HGorderx_, "number")},
	{"HGordery", tuple<int, string> (HGordery_, "number")},
	{"maxHGorderx", tuple<int, string> (maxHGorderx_, "number")},
	{"maxHGordery", tuple<int, string> (maxHGordery_, "number")},
	{"maxmode", tuple<int, string> (maxmode_, "number")},
	{"fcutoff", tuple<int, string> (fcutoff_, "number")},
	{"cutoff", tuple<int, string> (cutoff_, "number")},
	{"pulseE", tuple<int, string> (pulseE_, "number")},
	{"wavelen", tuple<int, string> (wavelen_, "number")},
	{"pulselen", tuple<int, string> (pulselen_, "number")},
	{"tlpulselen", tuple<int, string> (tlpulselen_, "number")},
	{"srcsize", tuple<int, string> (srcsize_, "number")},
	{"waistpos", tuple<int, string> (waistpos_, "number")},
	{"timing", tuple<int, string> (timing_, "number")},
	{"gdd", tuple<int, string> (gdd_, "number")},
	{"tod", tuple<int, string> (tod_, "number")},
	{"radstep", tuple<int, string> (radstep_, "number")},
	{"particles", tuple<int, string> (particles_, "number")},
	{"edevstep", tuple<int, string> (edevstep_, "number")},
	{"R56", tuple<int, string> (R56_, "number")},
	{"hrange", tuple<int, string> (hrange_, "array")},
	{"erange", tuple<int, string> (erange_, "array")},
	{"xyfix", tuple<int, string> (xyfix_, "array")},
	{"qxyfix", tuple<int, string> (qxyfix_, "array")},
	{"slitpos", tuple<int, string> (slitpos_, "array")},
	{"qslitpos", tuple<int, string> (qslitpos_, "array")},
	{"nslitapt", tuple<int, string> (nslitapt_, "array")},
	{"slitapt", tuple<int, string> (slitapt_, "array")},
	{"qslitapt", tuple<int, string> (qslitapt_, "array")},
	{"slitr", tuple<int, string> (slitr_, "array")},
	{"slitq", tuple<int, string> (slitq_, "array")},
	{"zrange", tuple<int, string> (zrange_, "array")},
	{"xrange", tuple<int, string> (xrange_, "array")},
	{"qxrange", tuple<int, string> (qxrange_, "array")},
	{"wnxrange", tuple<int, string> (wnxrange_, "array")},
	{"wdxrange", tuple<int, string> (wdxrange_, "array")},
	{"wndxrange", tuple<int, string> (wndxrange_, "array")},
	{"yrange", tuple<int, string> (yrange_, "array")},
	{"qyrange", tuple<int, string> (qyrange_, "array")},
	{"wnyrange", tuple<int, string> (wnyrange_, "array")},
	{"wdyrange", tuple<int, string> (wdyrange_, "array")},
	{"wndyrange", tuple<int, string> (wndyrange_, "array")},
	{"rrange", tuple<int, string> (rrange_, "array")},
	{"qrange", tuple<int, string> (qrange_, "array")},
	{"phirange", tuple<int, string> (phirange_, "array")},
	{"drange", tuple<int, string> (drange_, "array")},
	{"krange", tuple<int, string> (krange_, "array")},
	{"ckrange", tuple<int, string> (ckrange_, "array")},
	{"trange", tuple<int, string> (trange_, "array")},
	{"gtacc", tuple<int, string> (gtacc_, "array")},
	{"Xrange", tuple<int, string> (Xrange_, "array")},
	{"Xprange", tuple<int, string> (Xprange_, "array")},
	{"Yrange", tuple<int, string> (Yrange_, "array")},
	{"Yprange", tuple<int, string> (Yprange_, "array")},
	{"fieldrangexy", tuple<int, string> (fieldrangexy_, "array")},
	{"fieldgridxy", tuple<int, string> (fieldgridxy_, "array")},
	{"HGorderxy", tuple<int, string> (HGorderxy_, "array")},
	{"maxHGorderxy", tuple<int, string> (maxHGorderxy_, "array")},
	{"pulseE_d", tuple<int, string> (pulseE_d_, "array")},
	{"wavelen_d", tuple<int, string> (wavelen_d_, "array")},
	{"tlpulselen_d", tuple<int, string> (tlpulselen_d_, "array")},
	{"srcsize_d", tuple<int, string> (srcsize_d_, "array")},
	{"waistpos_d", tuple<int, string> (waistpos_d_, "array")},
	{"timing_d", tuple<int, string> (timing_d_, "array")},
	{"gdd_d", tuple<int, string> (gdd_d_, "array")},
	{"tod_d", tuple<int, string> (tod_d_, "array")},
	{"svstep", tuple<int, string> (svstep_, "array")},
	{"eproi", tuple<int, string> (eproi_, "array")},
	{"autoe", tuple<int, string> (autoe_, "boolean")},
	{"autot", tuple<int, string> (autot_, "boolean")},
	{"aprofile", tuple<int, string> (aprofile_, "boolean")},
	{"wigner", tuple<int, string> (wigner_, "boolean")},
	{"csd", tuple<int, string> (csd_, "boolean")},
	{"degcoh", tuple<int, string> (degcoh_, "boolean")},
	{"normenergy", tuple<int, string> (normenergy_, "boolean")},
	{"powlimit", tuple<int, string> (powlimit_, "boolean")},
	{"optDx", tuple<int, string> (optDx_, "boolean")},
	{"fouriep", tuple<int, string> (fouriep_, "boolean")},
	{"wiggapprox", tuple<int, string> (wiggapprox_, "boolean")},
	{"esmooth", tuple<int, string> (esmooth_, "boolean")},
	{"CMD", tuple<int, string> (CMD_, "boolean")},
	{"GSModel", tuple<int, string> (GSModel_, "boolean")},
	{"CMDint", tuple<int, string> (CMDint_, "boolean")},
	{"CMDcmp", tuple<int, string> (CMDcmp_, "boolean")},
	{"CMDcmpint", tuple<int, string> (CMDcmpint_, "boolean")},
	{"exportInt", tuple<int, string> (exportInt_, "boolean")},
	{"R56Bunch", tuple<int, string> (R56Bunch_, "boolean")},
	{"exportEt", tuple<int, string> (exportEt_, "boolean")},
	{"gridspec", tuple<int, string> (gridspec_, "selection")},
	{"optics", tuple<int, string> (optics_, "selection")},
	{"filter", tuple<int, string> (filter_, "selection")},
	{"dstep", tuple<int, string> (dstep_, "selection")},
	{"defobs", tuple<int, string> (defobs_, "selection")},
	{"estep", tuple<int, string> (estep_, "selection")},
	{"aperture", tuple<int, string> (aperture_, "selection")},
	{"accuracy", tuple<int, string> (accuracy_, "selection")},
	{"GSModelXY", tuple<int, string> (GSModelXY_, "selection")},
	{"CMDfld", tuple<int, string> (CMDfld_, "selection")},
	{"fel", tuple<int, string> (fel_, "selection")},
	{"Conftype", tuple<int, string> (Conftype_, "string")},
	{"fmateri", tuple<int, string> (fmateri_, "grid")},
	{"fcustom", tuple<int, string> (fcustom_, "data")},
	{"amateri", tuple<int, string> (amateri_, "grid")},
	{"depthdata", tuple<int, string> (depthdata_, "data")},
	{"seedspec", tuple<int, string> (seedspec_, "data")}
};

const vector<double> DefConfPrm {
	30, 1, 5, 0, 2, 2, 101, 1,
	12661, 10, 3, 3, 90, 90, 90, 90,
	0.3, 21, 0, 41, 51, 41, 51, 41,
	41, 41, 41, 25, 0.2, 0.4, 0.1, 0.2,
	0.001, 0.02, 0, 1000, 10, 10, 51, 10001,
	0.1, 0, 0, 0, 0, 51, 41, 51,
	41, 10000, 100, 100, 1, 1, 1, 0,
	1, 0.2, 0.005, 0.002, 50, 50, 50, 50,
	100, 0.001, 0.0001, 0.1, 267, 40, 40, 1,
	0, 0, 0, 0, 5, 1000000, 0.0001, 0
};

const vector<vector<double>> DefConfVec {
	{1, 5}, {5000, 50000}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {4, 4}, {2, 1},
	{0.06, 0.03}, {0, 1}, {0, 0.03}, {5, 6}, {-1, 1}, {-0.03, 0.03}, {-4, 4}, {-0.1, 0.1},
	{-0.1, 0.1}, {-0.5, 0.5}, {-0.02, 0.02}, {-4, 4}, {-0.1, 0.1}, {-0.1, 0.1}, {0, 1}, {0, 0.03},
	{0, 90}, {0, 1}, {0, 2.3}, {0, 5}, {-0.05, 0.05}, {1, 1}, {-1, 1}, {-0.05, 0.05},
	{-0.04, 0.04}, {-0.02, 0.02}, {1, 0.2}, {0.005, 0.002}, {50, 50}, {50, 50}, {0.1, 0.1}, {267, 280},
	{40, 40}, {1, 1}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {-1, 0.1}, {1, 120}
};

const vector<bool> DefConfBool {
	false, false, false, false, false, false, false, false,
	true, false, false, false, false, false, false, false,
	false, true, false, false
};

const vector<string> DefConfSel {
	"Automatic", "None", "None", "Linear",
	"Position", "Linear", "Fixed", "Default",
	"None", "None", "None"
};

const vector<string> DefConfStr {
	"Far Field & Ideal Condition::Energy Dependence::Angular Flux Density"
};

// Output File
enum OutfileIndex {
	serial_ = 0, NumOutfilePrm,
	format_ = 0, NumOutfileSel,
	folder_ = 0, prefix_, comment_, NumOutfileStr,
	fixpdata_ = 0, NumOutfileData
};

const map<string, tuple<int, string>> Outfile {
	{"Serial Number", tuple<int, string> (serial_, "number")},
	{"Format", tuple<int, string> (format_, "selection")},
	{"Folder", tuple<int, string> (folder_, "string")},
	{"Prefix", tuple<int, string> (prefix_, "string")},
	{"Comment", tuple<int, string> (comment_, "string")},
	{"Output Data", tuple<int, string> (fixpdata_, "grid")}
};

const map<string, tuple<int, string>> OutfileSimple {
	{"serial", tuple<int, string> (serial_, "number")},
	{"format", tuple<int, string> (format_, "selection")},
	{"folder", tuple<int, string> (folder_, "string")},
	{"prefix", tuple<int, string> (prefix_, "string")},
	{"comment", tuple<int, string> (comment_, "string")},
	{"fixpdata", tuple<int, string> (fixpdata_, "grid")}
};

const vector<double> DefOutfilePrm {
	-1
};

const vector<vector<double>> DefOutfileVec {};

const vector<bool> DefOutfileBool {};

const vector<string> DefOutfileSel {
	"JSON"
};

const vector<string> DefOutfileStr {
	"", "Untitled", ""
};

// Numerical Accuracy
enum AccuracyIndex {
	accdisctra_ = 0, accinobs_, accineE_, accinpE_, acclimtra_, acclimobs_, acclimpE_, acclimeE_,
		accconvharm_, accconvMC_, accconvMCcoh_, accMCpart_, NumAccuracyPrm,
	accEcorr_ = 0, acclimMCpart_, NumAccuracyBool
};

const map<string, tuple<int, string>> Accuracy {
	{"Longitudinal Step", tuple<int, string> (accdisctra_, "number")},
	{"Transverse Grid", tuple<int, string> (accinobs_, "number")},
	{"Electron Energy Step", tuple<int, string> (accineE_, "number")},
	{"Photon Energy Step", tuple<int, string> (accinpE_, "number")},
	{"Longitudinal Range", tuple<int, string> (acclimtra_, "number")},
	{"Transverse Range", tuple<int, string> (acclimobs_, "number")},
	{"Photon Energy Range", tuple<int, string> (acclimpE_, "number")},
	{"Electron Energy Range", tuple<int, string> (acclimeE_, "number")},
	{"Harmonic Convergence", tuple<int, string> (accconvharm_, "number")},
	{"Monte Carlo Integral Tolerance", tuple<int, string> (accconvMC_, "number")},
	{"Coherent Radiation Integral Tolerance", tuple<int, string> (accconvMCcoh_, "number")},
	{"Maximum Macroparticles", tuple<int, string> (accMCpart_, "number")},
	{"Energy Consistency", tuple<int, string> (accEcorr_, "boolean")},
	{"Limit Macroparticles", tuple<int, string> (acclimMCpart_, "boolean")}
};

const map<string, tuple<int, string>> AccuracySimple {
	{"accdisctra", tuple<int, string> (accdisctra_, "number")},
	{"accinobs", tuple<int, string> (accinobs_, "number")},
	{"accineE", tuple<int, string> (accineE_, "number")},
	{"accinpE", tuple<int, string> (accinpE_, "number")},
	{"acclimtra", tuple<int, string> (acclimtra_, "number")},
	{"acclimobs", tuple<int, string> (acclimobs_, "number")},
	{"acclimpE", tuple<int, string> (acclimpE_, "number")},
	{"acclimeE", tuple<int, string> (acclimeE_, "number")},
	{"accconvharm", tuple<int, string> (accconvharm_, "number")},
	{"accconvMC", tuple<int, string> (accconvMC_, "number")},
	{"accconvMCcoh", tuple<int, string> (accconvMCcoh_, "number")},
	{"accMCpart", tuple<int, string> (accMCpart_, "number")},
	{"accEcorr", tuple<int, string> (accEcorr_, "boolean")},
	{"acclimMCpart", tuple<int, string> (acclimMCpart_, "boolean")}
};

const vector<double> DefAccuracyPrm {
	1, 1, 1, 1, 1, 1, 1, 1,
	1, 0.1, 0.3, 1000000
};

const vector<vector<double>> DefAccuracyVec {};

const vector<bool> DefAccuracyBool {
	false, false
};

const vector<string> DefAccuracySel {};

const vector<string> DefAccuracyStr {};

// Particle Data Format
enum PartFormatIndex {
	colx_ = 0, colxp_, coly_, colyp_, colt_, colE_, pcharge_, bins_,
		NumPartFormatPrm,
	unitxy_ = 0, unitxyp_, unitt_, unitE_, NumPartFormatSel
};

const map<string, tuple<int, string>> PartFormat {
	{"x", tuple<int, string> (colx_, "number")},
	{"x'", tuple<int, string> (colxp_, "number")},
	{"y", tuple<int, string> (coly_, "number")},
	{"y'", tuple<int, string> (colyp_, "number")},
	{"t", tuple<int, string> (colt_, "number")},
	{"E", tuple<int, string> (colE_, "number")},
	{"Charge/Particle (C)", tuple<int, string> (pcharge_, "number")},
	{"Slices in 1&sigma;<sub>s</sub>", tuple<int, string> (bins_, "number")},
	{"x & y", tuple<int, string> (unitxy_, "selection")},
	{"x' & y'", tuple<int, string> (unitxyp_, "selection")},
	{"Time", tuple<int, string> (unitt_, "selection")},
	{"Energy", tuple<int, string> (unitE_, "selection")}
};

const map<string, tuple<int, string>> PartFormatSimple {
	{"colx", tuple<int, string> (colx_, "number")},
	{"colxp", tuple<int, string> (colxp_, "number")},
	{"coly", tuple<int, string> (coly_, "number")},
	{"colyp", tuple<int, string> (colyp_, "number")},
	{"colt", tuple<int, string> (colt_, "number")},
	{"colE", tuple<int, string> (colE_, "number")},
	{"pcharge", tuple<int, string> (pcharge_, "number")},
	{"bins", tuple<int, string> (bins_, "number")},
	{"unitxy", tuple<int, string> (unitxy_, "selection")},
	{"unitxyp", tuple<int, string> (unitxyp_, "selection")},
	{"unitt", tuple<int, string> (unitt_, "selection")},
	{"unitE", tuple<int, string> (unitE_, "selection")}
};

const vector<double> DefPartFormatPrm {
	1, 2, 3, 4, 5, 6, 1e-15, 100
};

const vector<vector<double>> DefPartFormatVec {};

const vector<bool> DefPartFormatBool {};

const vector<string> DefPartFormatSel {
	"m", "rad", "s", "GeV"
};

const vector<string> DefPartFormatStr {};

// Pre-Processing
enum PreprocIndex {
	thresh_ = 0, maxharm_, filtemin_, filtemax_, filtpoints_, NumPreprocPrm,
	zcoord_ = 0, filtauto_, filtscale_, NumPreprocSel
};

const map<string, tuple<int, string>> Preproc {
	{"Field Threshold (%)", tuple<int, string> (thresh_, "number")},
	{"Max. Harmonic", tuple<int, string> (maxharm_, "number")},
	{"Minimum Energy (eV)", tuple<int, string> (filtemin_, "number")},
	{"Maximum Energy (eV)", tuple<int, string> (filtemax_, "number")},
	{"Energy Points", tuple<int, string> (filtpoints_, "number")},
	{"Long. Coordinate", tuple<int, string> (zcoord_, "selection")},
	{"Plot Configuration", tuple<int, string> (filtauto_, "selection")},
	{"Energy Step", tuple<int, string> (filtscale_, "selection")}
};

const map<string, tuple<int, string>> PreprocSimple {
	{"thresh", tuple<int, string> (thresh_, "number")},
	{"maxharm", tuple<int, string> (maxharm_, "number")},
	{"filtemin", tuple<int, string> (filtemin_, "number")},
	{"filtemax", tuple<int, string> (filtemax_, "number")},
	{"filtpoints", tuple<int, string> (filtpoints_, "number")},
	{"zcoord", tuple<int, string> (zcoord_, "selection")},
	{"filtauto", tuple<int, string> (filtauto_, "selection")},
	{"filtscale", tuple<int, string> (filtscale_, "selection")}
};

const vector<double> DefPreprocPrm {
	90, 11, 1000, 100000, 1000
};

const vector<vector<double>> DefPreprocVec {};

const vector<bool> DefPreprocBool {};

const vector<string> DefPreprocSel {
	"Pole Number", "Automatic", "Linear"
};

const vector<string> DefPreprocStr {};

// import data format
const map<string, tuple<int, vector<string>>> DataFormat {
	{"Current Profile", tuple<int, vector<string>> (1, {"time (fs)","I (A)"})},
	{"E-t Profile", tuple<int, vector<string>> (2, {"time (fs)","DE/E","j (A/100%.E.S)"})},
	{"Field Profile", tuple<int, vector<string>> (1, {"z (m)","Bx (T)","By (T)"})},
	{"Field Profile (1 Period)", tuple<int, vector<string>> (1, {"z (m)","Bx (T)","By (T)"})},
	{"Gap vs. Field", tuple<int, vector<string>> (1, {"Gap (mm)","Bx (T)","By (T)"})},
	{"Custom Filter", tuple<int, vector<string>> (1, {"Energy (eV)","Transmission"})},
	{"Depth-Position Data", tuple<int, vector<string>> (0, {"Depth (mm)"})},
	{"Seed Spectrum", tuple<int, vector<string>> (1, {"Wavelength (nm)","Intensity","Phase (deg.)"})}
};

const map<string, tuple<int, vector<string>>> DataFormatSimple {
	{"currdata", tuple<int, vector<string>> (1, {"time (fs)","I (A)"})},
	{"Etdata", tuple<int, vector<string>> (2, {"time (fs)","DE/E","j (A/100%.E.S)"})},
	{"fvsz", tuple<int, vector<string>> (1, {"z (m)","Bx (T)","By (T)"})},
	{"fvsz1per", tuple<int, vector<string>> (1, {"z (m)","Bx (T)","By (T)"})},
	{"gaptbl", tuple<int, vector<string>> (1, {"Gap (mm)","Bx (T)","By (T)"})},
	{"fcustom", tuple<int, vector<string>> (1, {"Energy (eV)","Transmission"})},
	{"depthdata", tuple<int, vector<string>> (0, {"Depth (mm)"})},
	{"seedspec", tuple<int, vector<string>> (1, {"Wavelength (nm)","Intensity","Phase (deg.)"})}
};

// parameter categories
enum CategoryOrder {
	Acc_ = 0, Src_, Conf_, Outfile_, Accuracy_, PartFormat_, Preproc_, Categories
};

const vector<string>  CategoryNames {
	"Accelerator", "Light Source", "Configurations", "Output File", "Numerical Accuracy", "Particle Data Format", "Pre-Processing"
};

const vector<map<string, tuple<int, string>>>  ParameterFullNames {
	Acc, Src, Conf, Outfile, Accuracy, PartFormat, Preproc
};

const vector<map<string, tuple<int, string>>>  ParameterSimples {
	AccSimple, SrcSimple, ConfSimple, OutfileSimple, AccuracySimple, PartFormatSimple, PreprocSimple
};

const vector<vector<double>>  DefaultPrm {
	DefAccPrm, DefSrcPrm, DefConfPrm, DefOutfilePrm, DefAccuracyPrm, DefPartFormatPrm, DefPreprocPrm
};

const vector<vector<vector<double>>>  DefaultVec {
	DefAccVec, DefSrcVec, DefConfVec, DefOutfileVec, DefAccuracyVec, DefPartFormatVec, DefPreprocVec
};

const vector<vector<bool>>  DefaultBool {
	DefAccBool, DefSrcBool, DefConfBool, DefOutfileBool, DefAccuracyBool, DefPartFormatBool, DefPreprocBool
};

const vector<vector<string>>  DefaultSel {
	DefAccSel, DefSrcSel, DefConfSel, DefOutfileSel, DefAccuracySel, DefPartFormatSel, DefPreprocSel
};

const vector<vector<string>>  DefaultStr {
	DefAccStr, DefSrcStr, DefConfStr, DefOutfileStr, DefAccuracyStr, DefPartFormatStr, DefPreprocStr
};

const vector<string> ObsoleteLabels {
	"InjecPrm", "FerrPrms", "PerrPrms", "SegPrms",
	"Magnet Configurations", "BPF Parameter", "CMD Parameters", "FEL Configurations",
	"Options"
};

const int JSONIndent = 2;

#endif