# -*- coding: utf-8 -*-
"""
Created on Sun Jan  8 14:55:27 2017

@author: Notebook
"""

"""
This is the "nester.py" module, and it provides one function called print_lol()
which prints list that may or may not include nested lists.
"""

def print_lol(the_list, indent=False, level=0):
    """
    This function takes a positional argument called "the_list" which is any Python
    list (of, possibly, nested lists). Each data item in the provided list is
    (recursively) printed to the screen on its own line.
    The second argument called "indent" is an optional argument and used to switch on indent, default value is false. 
    The third argument called "level" is an optional argument and used to insert a specific tab-stops when a nested
    list is encountered, default value is 0.
    """
    for each_item in the_list:
        if isinstance(each_item, list):
            print_lol(each_item, indent, level+1)
        else:
            if indent :
                for tab_stop in range(level):
                    print("\t",end='')
            print(each_item)