/*
 * Decompiled with CFR 0.152.
 */
package org.jpype;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.sql.DriverManager;
import org.jpype.proxy.JPypeInvocationHandler;

public class Utility {
    static boolean hasCallerSensitive = false;

    public static boolean isCallerSensitive(Method method) {
        if (hasCallerSensitive) {
            for (Annotation annotation : method.getAnnotations()) {
                if (!"@jdk.internal.reflect.CallerSensitive()".equals(annotation.toString())) continue;
                return true;
            }
        } else {
            Class<?> clazz = method.getDeclaringClass();
            if (clazz.equals(Class.class) || clazz.equals(ClassLoader.class) || clazz.equals(DriverManager.class)) {
                return true;
            }
        }
        return false;
    }

    public static Object callMethod(Method method, Object object, Object[] objectArray) throws Throwable {
        try {
            return method.invoke(object, objectArray);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw invocationTargetException.getCause();
        }
    }

    public static Class<?> getClassFor(Object object) {
        Class<?> clazz = object.getClass();
        if (Proxy.isProxyClass(clazz) && Proxy.getInvocationHandler(object) instanceof JPypeInvocationHandler) {
            return JPypeInvocationHandler.class;
        }
        if (clazz.isSynthetic()) {
            return clazz.getInterfaces()[0];
        }
        return clazz;
    }

    static {
        try {
            Method method = Class.class.getDeclaredMethod("forName", String.class);
            for (Annotation annotation : method.getAnnotations()) {
                if (!"@jdk.internal.reflect.CallerSensitive()".equals(annotation.toString())) continue;
                hasCallerSensitive = true;
            }
        }
        catch (NoSuchMethodException | SecurityException exception) {
            // empty catch block
        }
    }
}

