/*
 * Decompiled with CFR 0.152.
 */
package org.jpype.classloader;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.TreeMap;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;

public class JPypeClassLoader
extends ClassLoader {
    private static JPypeClassLoader instance;
    private TreeMap<String, byte[]> map = new TreeMap();

    public static JPypeClassLoader getInstance() {
        if (instance == null) {
            instance = new JPypeClassLoader(JPypeClassLoader.getSystemClassLoader());
        }
        return instance;
    }

    private JPypeClassLoader(ClassLoader classLoader) {
        super(classLoader);
    }

    public void importClass(String string, byte[] byArray) {
        if (string.endsWith(".class")) {
            string = string.substring(0, string.length() - 6);
        }
        string = string.replaceAll("/", ".");
        this.map.put(string, byArray);
    }

    public void importJar(byte[] byArray) {
        try (JarInputStream jarInputStream = new JarInputStream(new ByteArrayInputStream(byArray));){
            JarEntry jarEntry;
            while ((jarEntry = jarInputStream.getNextJarEntry()) != null) {
                int n;
                long l = jarEntry.getSize();
                if (l <= 0L) continue;
                byte[] byArray2 = new byte[(int)l];
                int n2 = 0;
                while ((n = jarInputStream.read(byArray2, n2, byArray2.length - n2)) != 0 && (long)(n2 += n) != l) {
                }
                String string = jarEntry.getName();
                if (!string.endsWith(".class")) continue;
                this.importClass(string, byArray2);
            }
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    public Class findClass(String string) throws ClassNotFoundException, ClassFormatError {
        byte[] byArray = this.map.get(string);
        if (byArray == null) {
            return super.findClass(string);
        }
        Class<?> clazz = this.defineClass(string, byArray, 0, byArray.length);
        if (clazz == null) {
            throw new ClassFormatError("Class load was null");
        }
        return clazz;
    }
}

