/*
 * Decompiled with CFR 0.152.
 */
package org.jpype.compiler;

import java.util.Arrays;
import java.util.List;
import javax.tools.DiagnosticCollector;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.ToolProvider;
import org.jpype.classloader.JPypeClassLoader;
import org.jpype.compiler.MemoryCodeObject;
import org.jpype.compiler.MemoryFileManager;
import org.jpype.compiler.MemorySourceObject;

public class MemoryCompiler {
    public DiagnosticCollector<JavaFileObject> diagnostics;

    public Class<?> compile(String string, String string2) {
        try {
            List<MemorySourceObject> list = Arrays.asList(new MemorySourceObject(string, string2));
            JavaCompiler javaCompiler = ToolProvider.getSystemJavaCompiler();
            this.diagnostics = new DiagnosticCollector();
            StandardJavaFileManager standardJavaFileManager = javaCompiler.getStandardFileManager(null, null, null);
            MemoryFileManager memoryFileManager = new MemoryFileManager(standardJavaFileManager);
            JavaCompiler.CompilationTask compilationTask = javaCompiler.getTask(null, memoryFileManager, null, null, null, list);
            boolean bl = compilationTask.call();
            if (!bl) {
                return null;
            }
            JPypeClassLoader jPypeClassLoader = JPypeClassLoader.getInstance();
            for (MemoryCodeObject memoryCodeObject : memoryFileManager.getCode()) {
                jPypeClassLoader.importClass(memoryCodeObject.getName(), memoryCodeObject.toByteArray());
            }
            return jPypeClassLoader.loadClass(string);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public DiagnosticCollector<JavaFileObject> getDiagnostics() {
        return this.diagnostics;
    }
}

