/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.proactive.scheduler.common.job.factories;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EmptyStackException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import org.objectweb.proactive.annotation.PublicAPI;
import org.ow2.proactive.scheduler.common.job.TaskFlowJob;
import org.ow2.proactive.scheduler.common.job.factories.FlowError;
import org.ow2.proactive.scheduler.common.task.Task;
import org.ow2.proactive.scheduler.common.task.flow.FlowActionType;
import org.ow2.proactive.scheduler.common.task.flow.FlowBlock;

@PublicAPI
public class FlowChecker {
    private TaskFlowJob job;
    private List<Block> blocks;
    private List<TaskTree> roots;
    private List<TaskTree> tasksFlat;

    private FlowChecker(TaskFlowJob job, List<Block> blocks) throws FlowError {
        this.job = job;
        this.blocks = blocks != null ? blocks : new ArrayList<Block>();
        this.blocks.clear();
        this.createTaskTree(job);
    }

    public static FlowError validate(TaskFlowJob job) {
        return FlowChecker.validate(job, null);
    }

    public static FlowError validate(TaskFlowJob job, List<Block> blocks) {
        FlowError error = null;
        try {
            FlowChecker fc = new FlowChecker(job, blocks);
            fc.checkNames();
            fc.checkRecursion();
            fc.checkReachable();
            fc.checkBlocks();
            fc.checkReplicate();
            fc.checkLoop();
            fc.checkIf();
        }
        catch (FlowError e) {
            error = e;
        }
        return error;
    }

    private void checkNames() throws FlowError {
        HashSet<String> tasks = new HashSet<String>();
        for (Task task : this.job.getTasks()) {
            String name = task.getName();
            if (name.indexOf("#") != -1) {
                throw new FlowError("Task name cannot contain special character '#'", FlowError.FlowErrorType.NAME, name);
            }
            if (name.indexOf("*") != -1) {
                throw new FlowError("Task name cannot contain special character '*'", FlowError.FlowErrorType.NAME, name);
            }
            if (tasks.contains(name)) {
                throw new FlowError("Task names are not unique", FlowError.FlowErrorType.NAME, name);
            }
            tasks.add(name);
        }
    }

    private void checkRecursion() throws FlowError {
        for (TaskTree tree : this.roots) {
            LinkedList<TaskTree> env = new LinkedList<TaskTree>();
            this.internalCheckRecursion(env, tree);
        }
    }

    private void internalCheckRecursion(LinkedList<TaskTree> env, TaskTree cur) throws FlowError {
        LinkedList<TaskTree> n;
        for (TaskTree t : env) {
            if (!t.equals(cur)) continue;
            throw new FlowError("Infinite recursion detected", FlowError.FlowErrorType.RECURSION, t.element.getName());
        }
        env.addFirst(cur);
        if (cur.children != null && cur.children.size() > 0) {
            for (TaskTree child : cur.children) {
                n = new LinkedList<TaskTree>(env);
                this.internalCheckRecursion(n, child);
            }
        }
        if (cur.targets != null && cur.targets.size() > 0) {
            for (TaskTree child : cur.targets) {
                n = new LinkedList<TaskTree>(env);
                this.internalCheckRecursion(n, child);
            }
        }
        if (cur.joinedBy != null) {
            LinkedList<TaskTree> n2 = new LinkedList<TaskTree>(env);
            this.internalCheckRecursion(n2, cur.joinedBy);
        }
    }

    private void checkReachable() throws FlowError {
        boolean change;
        HashSet<Task> tasks = new HashSet<Task>();
        HashSet<Task> reached = new HashSet<Task>();
        for (Task t : this.job.getTasks()) {
            if (t.getDependencesList() == null) {
                reached.add(t);
                continue;
            }
            tasks.add(t);
        }
        do {
            change = false;
            Iterator it = tasks.iterator();
            while (it.hasNext()) {
                Task t = (Task)it.next();
                if (!reached.containsAll(t.getDependencesList())) continue;
                it.remove();
                reached.add(t);
                change = true;
            }
        } while (change);
        if (reached.size() != this.job.getTasks().size()) {
            for (Task t : this.job.getTasks()) {
                if (reached.contains(t)) continue;
                throw new FlowError("Unreachable task", FlowError.FlowErrorType.UNREACHABLE, t.getName());
            }
        }
    }

    private void checkBlocks() throws FlowError {
        HashSet<String> done = new HashSet<String>();
        for (TaskTree tt : this.roots) {
            Stack<TaskTree> env = new Stack<TaskTree>();
            Stack<TaskTree> join = new Stack<TaskTree>();
            this.dfsBlocks(tt, done, env, join);
            if (env.size() <= 0) continue;
            throw new FlowError("Unmatched start block", FlowError.FlowErrorType.BLOCK, ((TaskTree)env.firstElement()).element.getName());
        }
        for (Block b : this.blocks) {
            FlowChecker.checkBlockDown(b.end, b.start);
            FlowChecker.checkBlockUp(b.start, b.end);
        }
    }

    private void dfsBlocks(TaskTree tree, Set<String> done, Stack<TaskTree> env, Stack<TaskTree> join) throws FlowError {
        if (tree.joins.size() > 0 && !tree.joinTrigger) {
            return;
        }
        if (tree.targetOf != null && !done.contains(tree.targetOf.element.getName())) {
            return;
        }
        FlowBlock fb = tree.element.getFlowBlock();
        String name = tree.element.getName();
        if (done.contains(name)) {
            return;
        }
        done.add(name);
        switch (fb) {
            case START: {
                env.push(tree);
                break;
            }
            case END: {
                TaskTree start = null;
                try {
                    start = env.pop();
                }
                catch (EmptyStackException e) {
                    throw new FlowError("Unmatched end block", FlowError.FlowErrorType.BLOCK, name);
                }
                Block blk = new Block(start, tree);
                this.blocks.add(blk);
                break;
            }
        }
        ArrayList<TaskTree> children = new ArrayList<TaskTree>();
        children.addAll(tree.children);
        if (tree.children.size() == 0) {
            if (tree.element.getFlowScript() != null && tree.element.getFlowScript().getActionType().equals(FlowActionType.IF.toString())) {
                if (tree.targetJoin != null) {
                    join.add(tree.targetJoin);
                }
                for (TaskTree t : tree.targets) {
                    children.add(t);
                }
            } else if (join.size() > 0) {
                TaskTree pop = join.pop();
                children.add(pop);
                pop.joinTrigger = true;
            }
        }
        for (TaskTree child : children) {
            this.dfsBlocks(child, done, env, join);
        }
    }

    private void createTaskTree(TaskFlowJob job) throws FlowError {
        ArrayList<TaskTree> roots = new ArrayList<TaskTree>();
        HashMap<String, TaskTree> tasks = new HashMap<String, TaskTree>();
        for (Task t : job.getTasks()) {
            TaskTree tt = new TaskTree(t);
            tasks.put(t.getName(), tt);
        }
        for (TaskTree treeDown : tasks.values()) {
            TaskTree tt;
            List<Task> deps = treeDown.element.getDependencesList();
            if (deps == null) {
                roots.add(treeDown);
            } else {
                for (Task dep : deps) {
                    TaskTree treeUp = (TaskTree)tasks.get(dep.getName());
                    treeUp.children.add(treeDown);
                    treeDown.parents.add(treeUp);
                }
            }
            if (treeDown.element.getFlowScript() == null || !treeDown.element.getFlowScript().getActionType().equals(FlowActionType.IF.toString())) continue;
            String tT = treeDown.element.getFlowScript().getActionTarget();
            String tE = treeDown.element.getFlowScript().getActionTargetElse();
            String tJ = treeDown.element.getFlowScript().getActionContinuation();
            if (tT != null) {
                tt = (TaskTree)tasks.get(tT);
                if (tt == null) {
                    throw new FlowError("IF target is null", FlowError.FlowErrorType.IF, treeDown.element.getName());
                }
                if (tt.targetOf != null) {
                    throw new FlowError("Task is target of multiple IF actions", FlowError.FlowErrorType.IF, tT);
                }
                tt.targetOf = treeDown;
                treeDown.targets.add(tt);
            }
            if (tE != null) {
                tt = (TaskTree)tasks.get(tE);
                if (tt == null) {
                    throw new FlowError("ELSE target is null", FlowError.FlowErrorType.IF, treeDown.element.getName());
                }
                if (tt.targetOf != null) {
                    throw new FlowError("Task is target of multiple IF actions", FlowError.FlowErrorType.IF, tE);
                }
                tt.targetOf = treeDown;
                treeDown.targets.add(tt);
            }
            if (tJ == null) continue;
            treeDown.targetJoin = (TaskTree)tasks.get(tJ);
        }
        for (TaskTree tree : tasks.values()) {
            String tJ;
            if (tree.element.getFlowScript() == null || !tree.element.getFlowScript().getActionType().equals(FlowActionType.IF.toString()) || (tJ = tree.element.getFlowScript().getActionContinuation()) == null || tJ.length() <= 0) continue;
            TaskTree ifT = (TaskTree)tasks.get(tree.element.getFlowScript().getActionTarget());
            TaskTree elseT = (TaskTree)tasks.get(tree.element.getFlowScript().getActionTargetElse());
            ArrayList<TaskTree> tgs = new ArrayList<TaskTree>(2);
            tgs.add(ifT);
            tgs.add(elseT);
            Iterator iterator = tgs.iterator();
            while (iterator.hasNext()) {
                TaskTree tree2;
                TaskTree target = tree2 = (TaskTree)iterator.next();
                TaskTree target2 = null;
                Stack<String> jOpen = new Stack<String>();
                TaskTree joinTask = (TaskTree)tasks.get(tJ);
                do {
                    String jT;
                    target2 = target;
                    if (target.element.getFlowScript() != null && target.element.getFlowScript().getActionContinuation() != null && (jT = target.element.getFlowScript().getActionContinuation()) != null && jT.length() > 0) {
                        jOpen.push(jT);
                    }
                    target = null;
                    if (target2.children.size() > 0) {
                        target = target2.children.get(0);
                    }
                    if (target == null && target2.element.getFlowScript() != null) {
                        target = (TaskTree)tasks.get(target2.element.getFlowScript().getActionTargetElse());
                    }
                    if (target != null || jOpen.size() <= 0) continue;
                    target = (TaskTree)tasks.get(jOpen.pop());
                } while (target != null);
                if (joinTask == null) continue;
                joinTask.joins.add(target2);
                target2.joinedBy = joinTask;
            }
        }
        Collection values = tasks.values();
        this.tasksFlat = new ArrayList<TaskTree>(values.size());
        for (TaskTree t : values) {
            this.tasksFlat.add(t);
        }
        this.roots = roots;
    }

    private static void checkBlockDown(TaskTree endBlock, TaskTree node) throws FlowError {
        ArrayList<TaskTree> children = new ArrayList<TaskTree>();
        children.addAll(node.children);
        children.addAll(node.targets);
        if (node.joinedBy != null) {
            children.add(node.joinedBy);
        }
        if (node.element.getName().equals(endBlock.element.getName())) {
            return;
        }
        if (children.size() == 0) {
            throw new FlowError("Task Block ending at " + endBlock.element.getName() + " does not join all its flows", FlowError.FlowErrorType.BLOCK, node.element.getName());
        }
        for (TaskTree child : children) {
            if (child == null) continue;
            FlowChecker.checkBlockDown(endBlock, child);
        }
    }

    private static void checkBlockUp(TaskTree startBlock, TaskTree node) throws FlowError {
        ArrayList<TaskTree> parents = new ArrayList<TaskTree>();
        parents.addAll(node.parents);
        parents.addAll(node.joins);
        if (node.targetOf != null) {
            parents.add(node.targetOf);
        }
        if (node.element.getName().equals(startBlock.element.getName())) {
            return;
        }
        if (parents.size() == 0) {
            throw new FlowError("Task Block starting at " + startBlock.element.getName() + " has external dependencies", FlowError.FlowErrorType.BLOCK, node.element.getName());
        }
        for (TaskTree parent : parents) {
            if (parent == null) continue;
            FlowChecker.checkBlockUp(startBlock, parent);
        }
    }

    private TaskTree findTask(String task) {
        for (TaskTree tree : this.tasksFlat) {
            if (!tree.element.getName().equals(task)) continue;
            return tree;
        }
        return null;
    }

    private void checkReplicate() throws FlowError {
        for (TaskTree tree : this.tasksFlat) {
            if (tree.element.getFlowScript() == null || !tree.element.getFlowScript().getActionType().equals(FlowActionType.REPLICATE.toString())) continue;
            for (TaskTree child : tree.children) {
                if (child.parents.size() != 1) {
                    throw new FlowError("The Target of a REPLICATE must have only one dependency", FlowError.FlowErrorType.REPLICATE, child.element.getName());
                }
                if (child.element.getFlowBlock().equals((Object)FlowBlock.END)) {
                    throw new FlowError("The target of a REPLICATE cannot be the end of a task block", FlowError.FlowErrorType.REPLICATE, child.element.getName());
                }
                Block block = null;
                for (Block b : this.blocks) {
                    if (!b.start.element.getName().equals(child.element.getName())) continue;
                    block = b;
                }
                TaskTree endBlock = null;
                endBlock = block != null ? block.end : child;
                if (endBlock.children.size() < 1) {
                    throw new FlowError("No merge point for REPLICATE block", FlowError.FlowErrorType.REPLICATE, endBlock.element.getName());
                }
                if (endBlock.element.getFlowScript() == null || !endBlock.element.getFlowScript().getActionType().equals(FlowActionType.REPLICATE.toString()) && !endBlock.element.getFlowScript().getActionType().equals(FlowActionType.IF.toString())) continue;
                throw new FlowError("Last action of a REPLICATE block cannot perform IF or REPLICATE action", FlowError.FlowErrorType.REPLICATE, endBlock.element.getName());
            }
        }
    }

    private void checkIf() throws FlowError {
        for (TaskTree tree : this.tasksFlat) {
            if (tree.element.getFlowScript() == null || !tree.element.getFlowScript().getActionType().equals(FlowActionType.IF.toString())) continue;
            TaskTree targetIf = this.findTask(tree.element.getFlowScript().getActionTarget());
            TaskTree targetElse = this.findTask(tree.element.getFlowScript().getActionTargetElse());
            TaskTree targetJoin = this.findTask(tree.element.getFlowScript().getActionContinuation());
            if (targetIf == null) {
                throw new FlowError("IF action has no target", FlowError.FlowErrorType.IF, tree.element.getName());
            }
            if (targetElse == null) {
                throw new FlowError("IF action has no ELSE target", FlowError.FlowErrorType.IF, tree.element.getName());
            }
            if (targetIf.equals(targetElse)) {
                throw new FlowError("IF and ELSE targets are the same", FlowError.FlowErrorType.IF, targetIf.element.getName());
            }
            if (targetJoin == null) {
                if (targetIf.parents.size() > 0) {
                    throw new FlowError("IF target task cannot have dependencies", FlowError.FlowErrorType.IF, targetIf.element.getName());
                }
                if (targetElse.parents.size() > 0) {
                    throw new FlowError("IF target task ELSE cannot have dependencies", FlowError.FlowErrorType.IF, targetElse.element.getName());
                }
                ArrayList<TaskTree> targets = new ArrayList<TaskTree>(2);
                targets.add(targetIf);
                targets.add(targetElse);
                for (TaskTree target : targets) {
                    HashMap<String, TaskTree> ifTasks = new HashMap<String, TaskTree>();
                    Stack<TaskTree> stack = new Stack<TaskTree>();
                    stack.push(target);
                    while (stack.size() > 0) {
                        TaskTree cur = (TaskTree)stack.pop();
                        if (ifTasks.containsKey(cur.element.getName())) continue;
                        ifTasks.put(cur.element.getName(), cur);
                        for (TaskTree t : cur.children) {
                            stack.push(t);
                        }
                        for (TaskTree t : cur.targets) {
                            stack.push(t);
                        }
                    }
                    for (TaskTree t : ifTasks.values()) {
                        if (t.element.getName().equals(target.element.getName())) continue;
                        try {
                            FlowChecker.checkBlockUp(target, t);
                        }
                        catch (FlowError e) {
                            throw new FlowError("IF block at " + target.element.getName() + " has external dependencies", FlowError.FlowErrorType.IF, e.getTask());
                        }
                    }
                }
                continue;
            }
            Block ifBlock = null;
            Block elseBlock = null;
            for (Block b : this.blocks) {
                if (b.start.element.getName().equals(targetIf.element.getName())) {
                    ifBlock = b;
                }
                if (!b.start.element.getName().equals(targetElse.element.getName())) continue;
                elseBlock = b;
            }
            if (ifBlock == null) {
                if (targetIf.children.size() <= 0 && targetIf.targets.size() <= 0) {
                    ifBlock = new Block(targetIf, targetIf);
                } else {
                    throw new FlowError("IF action target is not a Task Block", FlowError.FlowErrorType.IF, targetIf.element.getName());
                }
            }
            if (elseBlock == null) {
                if (targetElse.children.size() <= 0 && targetElse.targets.size() <= 0) {
                    elseBlock = new Block(targetElse, targetElse);
                } else {
                    throw new FlowError("IF action ELSE target is not a Task Block", FlowError.FlowErrorType.IF, targetElse.element.getName());
                }
            }
            if (targetJoin != null) {
                for (TaskTree join : targetJoin.joins) {
                    String jN = join.element.getName();
                    if (jN.equals(ifBlock.end.element.getName()) || jN.equals(elseBlock.end.element.getName())) continue;
                    throw new FlowError("JOIN task merges multiple IF actions", FlowError.FlowErrorType.IF, targetJoin.element.getName());
                }
            }
            if (ifBlock.start.parents.size() > 0) {
                throw new FlowError("IF task block cannot have dependencies", FlowError.FlowErrorType.IF, ifBlock.start.element.getName());
            }
            if (ifBlock.end.children.size() > 0) {
                throw new FlowError("IF task block cannot have children", FlowError.FlowErrorType.IF, ifBlock.end.element.getName());
            }
            if (elseBlock.start.parents.size() > 0) {
                throw new FlowError("ELSE task block cannot have dependencies", FlowError.FlowErrorType.IF, elseBlock.start.element.getName());
            }
            if (elseBlock.end.children.size() > 0) {
                throw new FlowError("ELSE task block cannot have children", FlowError.FlowErrorType.IF, elseBlock.end.element.getName());
            }
            if (targetJoin.parents.size() <= 0) continue;
            throw new FlowError("JOIN task cannot have dependencies", FlowError.FlowErrorType.IF, targetJoin.element.getName());
        }
    }

    private void checkLoop() throws FlowError {
        for (TaskTree tree : this.tasksFlat) {
            if (tree.element.getFlowScript() == null || !tree.element.getFlowScript().getActionType().equals(FlowActionType.LOOP.toString())) continue;
            TaskTree target = this.findTask(tree.element.getFlowScript().getActionTarget());
            if (target == null) {
                throw new FlowError("LOOP action has no target", FlowError.FlowErrorType.LOOP, tree.element.getName());
            }
            boolean isBlock = false;
            for (Block b : this.blocks) {
                if (!b.start.element.getName().equals(target.element.getName()) || !b.end.element.getName().equals(tree.element.getName())) continue;
                isBlock = true;
                break;
            }
            if (target.element.getName().equals(tree.element.getName()) && target.element.getFlowBlock().equals((Object)FlowBlock.NONE) && tree.element.getFlowBlock().equals((Object)FlowBlock.NONE)) {
                isBlock = true;
            }
            if (!isBlock) {
                throw new FlowError("The scope of a LOOP action should be a Task Block", FlowError.FlowErrorType.LOOP, tree.element.getName());
            }
            if (target.parents.size() <= 1) continue;
            throw new FlowError("The Target of a LOOP must have only one dependency", FlowError.FlowErrorType.LOOP, target.element.getName());
        }
    }

    public static class TaskTree {
        public List<TaskTree> children = new ArrayList<TaskTree>();
        public List<TaskTree> parents = new ArrayList<TaskTree>();
        public Task element = null;
        public List<TaskTree> targets = new ArrayList<TaskTree>();
        public TaskTree targetOf = null;
        public TaskTree targetJoin = null;
        public List<TaskTree> joins = new ArrayList<TaskTree>();
        public TaskTree joinedBy = null;
        public boolean joinTrigger = false;

        public TaskTree(Task e) {
            this.element = e;
        }

        public String toString() {
            return this.element.getName();
        }
    }

    public static class Block {
        public TaskTree start = null;
        public TaskTree end = null;

        public Block(TaskTree a, TaskTree b) {
            this.start = a;
            this.end = b;
        }
    }
}

