/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.proactive.utils;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.Deflater;
import java.util.zip.Inflater;
import org.apache.commons.codec.binary.Base64;

public final class ObjectByteConverter {
    public static final byte[] objectToByteArray(Object obj) throws IOException {
        return ObjectByteConverter.objectToByteArray(obj, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final byte[] objectToByteArray(Object obj, boolean compress) throws IOException {
        ByteArrayOutputStream baos = null;
        ObjectOutputStream oos = null;
        if (obj == null) {
            return null;
        }
        try {
            byte[] byArray;
            block13: {
                baos = new ByteArrayOutputStream();
                oos = new ObjectOutputStream(baos);
                oos.writeObject(obj);
                oos.flush();
                if (!compress) {
                    byte[] byArray2 = baos.toByteArray();
                    return byArray2;
                }
                Deflater compressor = new Deflater();
                compressor.setLevel(9);
                compressor.setInput(baos.toByteArray());
                compressor.finish();
                ByteArrayOutputStream bos = null;
                try {
                    bos = new ByteArrayOutputStream();
                    byte[] buf = new byte[512];
                    while (!compressor.finished()) {
                        int count = compressor.deflate(buf);
                        bos.write(buf, 0, count);
                    }
                    byArray = bos.toByteArray();
                    if (bos == null) break block13;
                }
                catch (Throwable throwable) {
                    if (bos != null) {
                        bos.close();
                    }
                    throw throwable;
                }
                bos.close();
            }
            return byArray;
        }
        finally {
            if (oos != null) {
                oos.close();
            }
            if (baos != null) {
                baos.close();
            }
        }
    }

    public static Object byteArrayToObject(byte[] input) throws IOException, ClassNotFoundException {
        return ObjectByteConverter.byteArrayToObject(input, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object byteArrayToObject(byte[] input, boolean uncompress) throws IOException, ClassNotFoundException {
        if (input == null) {
            return null;
        }
        if (uncompress) {
            Inflater decompressor = new Inflater();
            decompressor.setInput(input);
            try (ByteArrayOutputStream bos = null;){
                bos = new ByteArrayOutputStream();
                byte[] buf = new byte[512];
                while (!decompressor.finished()) {
                    int count = decompressor.inflate(buf);
                    bos.write(buf, 0, count);
                }
                decompressor.end();
                input = bos.toByteArray();
            }
        }
        ByteArrayInputStream bais = null;
        ObjectInputStream ois = null;
        try {
            bais = new ByteArrayInputStream(input);
            ois = new ObjectInputStream(bais);
            Object object = ois.readObject();
            return object;
        }
        finally {
            if (ois != null) {
                ois.close();
            }
            if (bais != null) {
                bais.close();
            }
        }
    }

    public static String serializableToBase64String(Serializable input) throws IOException {
        return ObjectByteConverter.byteArrayToBase64String(ObjectByteConverter.objectToByteArray(input));
    }

    public static String byteArrayToBase64String(byte[] input) {
        if (input == null) {
            return null;
        }
        return new String(Base64.encodeBase64((byte[])input));
    }

    public static byte[] base64StringToByteArray(String input) {
        if (input == null) {
            return null;
        }
        return Base64.decodeBase64((String)input);
    }

    public static Serializable base64StringToSerializable(String input) throws IOException, ClassNotFoundException {
        if (input == null) {
            return null;
        }
        return (Serializable)ObjectByteConverter.byteArrayToObject(ObjectByteConverter.base64StringToByteArray(input));
    }

    public static Map<String, byte[]> mapOfBase64StringToByteArray(Map<String, String> input) {
        if (input == null) {
            return null;
        }
        HashMap<String, byte[]> answer = new HashMap<String, byte[]>(input.size());
        for (Map.Entry<String, String> entry : input.entrySet()) {
            answer.put(entry.getKey(), ObjectByteConverter.base64StringToByteArray(entry.getValue()));
        }
        return answer;
    }

    public static Map<String, Serializable> mapOfByteArrayToSerializable(Map<String, byte[]> input) throws IOException, ClassNotFoundException {
        if (input == null) {
            return null;
        }
        HashMap<String, Serializable> answer = new HashMap<String, Serializable>(input.size());
        for (Map.Entry<String, byte[]> entry : input.entrySet()) {
            answer.put(entry.getKey(), (Serializable)ObjectByteConverter.byteArrayToObject(entry.getValue()));
        }
        return answer;
    }
}

