########################################################################
# test/xslt/em_20001125.py
# Edmund Mitchell <> finds brokenness in format-number

import os
import cStringIO
import unittest

from amara.lib import treecompare
from amara.test import test_main
from amara.test.xslt import xslt_test, filesource, stringsource

class test_xslt_format_number_em_20001125(xslt_test):
    source = stringsource("""<doc>
   <number>-12345</number>
</doc>""")
    transform = stringsource("""<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
version="1.0">
 <xsl:template match="/doc">
   <xsl:value-of select="format-number(number, '#,###;(#)' )"/>
 </xsl:template>
</xsl:stylesheet>""")
    parameters = {}
    expected = """<?xml version="1.0" encoding="UTF-8"?>
(12,345)"""
#"

if __name__ == '__main__':
    test_main()

    
