# -*- coding: iso-8859-1 -*-
########################################################################
# test/xslt/ep_20020718.py
# See 
# http://lists.fourthought.com/pipermail/4suite/2002-July/003976.html 
#et seq.

import os
import cStringIO
import unittest

from amara.lib import treecompare
from amara.test import test_main
from amara.test.xslt import xslt_test, filesource, stringsource

commonsource = stringsource("""<?xml version="1.0" encoding="ISO-8859-1"?>
<test>Baron Mnchausen</test>
""")

class test_xslt_iso_8859_1_input_emitted_in_an_html_attribute_ep_20020718(xslt_test):
    source = commonsource
    transform = stringsource("""<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet version="1.0"
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
  <xsl:output method="html"/>
  <xsl:template match="/">
    <html>
      <head/>
      <body name="{.}"/>
    </html>
  </xsl:template>
</xsl:stylesheet>
""")
    parameters = {}
    expected = "<html>\n  <head>\n    <meta http-equiv='Content-Type' content='text/html; charset=iso-8859-1'>\n  </head>\n  <body name='Baron M&uuml;nchausen'></body>\n</html>"

class test_xslt_iso_8859_1_input_emitted_in_an_html_uri_attribute_ep_20020718(xslt_test):
    source = commonsource
    transform = stringsource("""<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet version="1.0"
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
  <xsl:output method="html"/>
  <xsl:template match="/">
    <html>
      <head/>
      <body background="{.}"/>
    </html>
  </xsl:template>
</xsl:stylesheet>
""")
    parameters = {}
    expected = "<html>\n  <head>\n    <meta http-equiv='Content-Type' content='text/html; charset=iso-8859-1'>\n  </head>\n  <body background='Baron M%C3%BCnchausen'></body>\n</html>"

class test_xslt_iso_8859_1_input_emitted_in_an_xml_attribute_ep_20020718(xslt_test):
    source = commonsource
    transform = stringsource("""<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet version="1.0"
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
  <xsl:output method="xml" encoding="ISO-8859-1"/>
  <xsl:template match="/">
    <link title="{.}"></link>
  </xsl:template>
</xsl:stylesheet>
""")
    parameters = {}
    expected = """<?xml version="1.0" encoding="ISO-8859-1"?>\n<link title='Baron Mnchausen'></link>"""

class test_xslt_iso_8859_1_input_emitted_in_an_xml_attribute_as_UTF_8_ep_20020718(xslt_test):
    source = commonsource
    transform = stringsource("""<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet version="1.0"
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
  <xsl:template match="/">
    <link title="{.}"></link>
  </xsl:template>
</xsl:stylesheet>
""")
    parameters = {}
    expected = """<?xml version="1.0" encoding="UTF-8"?>\n<link title='Baron M\xC3\xBCnchausen'></link>"""

if __name__ == '__main__':
    test_main()

