########################################################################
# test/xslt/jt_20001117.py
# Jeni Tennison <Jeni.Tennison@epistemics.co.uk> taunts her cross-pond 
# mates about politics and the self axis

import os
import cStringIO
import unittest

from amara.lib import treecompare
from amara.test import test_main
from amara.test.xslt import xslt_test, filesource, stringsource

class test_xslt_self_axis_1_jt_20001117(xslt_test):
    source = stringsource("""<vote xmlns:d="http://www.democrat.org/"
      xmlns:r="http://www.republican.org/">
   <county>Palm Beach</county>
   <d:count>31563</d:count>
   <r:count>23725</r:count>
</vote>""")
    transform = stringsource("""\
<xsl:stylesheet version="1.0"
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
  xmlns:dem="http://www.democrat.org/"
  xmlns:rep="http://www.republican.org/">

<xsl:template match="vote">
   <xsl:copy>
      <dem:count><xsl:value-of select="rep:count - 432" /></dem:count>
      <xsl:copy-of select="*[not(self::dem:count)]" />
   </xsl:copy>
</xsl:template>

</xsl:stylesheet>""")
    parameters = {}
    expected = """<?xml version='1.0' encoding='UTF-8'?>\n<vote xmlns:d='http://www.democrat.org/' xmlns:r='http://www.republican.org/'><dem:count xmlns:dem='http://www.democrat.org/' xmlns:rep='http://www.republican.org/'>23293</dem:count><county>Palm Beach</county><r:count>23725</r:count></vote>"""

class test_xslt_self_axis_2_jt_20001117(xslt_test):
    # This version forgets that the principal node type of the self axis is element
    source = stringsource("""<vote xmlns:d="http://www.democrat.org/"
      xmlns:r="http://www.republican.org/"
      county="Palm Beach"
      d:count="31563"
      r:count="23725"/>""")
    transform = stringsource("""<xsl:stylesheet version="1.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:dem="http://www.democrat.org/"
                xmlns:rep="http://www.republican.org/">

<xsl:template match="vote">
   <xsl:copy>
      <xsl:attribute name="dem:count" namespace="http://www.democrat.org/">
        <xsl:value-of select="@rep:count - 432" />
      </xsl:attribute>
      <xsl:copy-of select="@*[not(self::dem:count)]" />
   </xsl:copy>
</xsl:template>

</xsl:stylesheet>""")
    parameters = {}
    expected = """<?xml version='1.0' encoding='UTF-8'?>
<vote r:count='23725' county='Palm Beach' d:count='23293' xmlns:d='http://www.democrat.org/' xmlns:r='http://www.republican.org/'/>"""

class test_xslt_self_axis_1_jt_20001117(xslt_test):
    # The nastiness Jeni resorts to as a general solution to this
    source = stringsource("""<vote xmlns:d="http://www.democrat.org/"
      xmlns:r="http://www.republican.org/"
      county="Palm Beach"
      d:count="31563"
      r:count="23725"/>""")
    transform = stringsource("""<xsl:stylesheet version="1.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:dem="http://www.democrat.org/"
                xmlns:rep="http://www.republican.org/">

<xsl:template match="vote">
   <xsl:copy>
      <xsl:attribute name="dem:count" namespace="http://www.democrat.org/">
        <xsl:value-of select="@rep:count - 432" />
      </xsl:attribute>
      <xsl:copy-of select="@*[not(local-name() = 'count' and namespace-uri() = document('')/*/namespace::dem)]" />
   </xsl:copy>
</xsl:template>

</xsl:stylesheet>""")
    parameters = {}
    expected = """<?xml version='1.0' encoding='UTF-8'?>
<vote r:count='23725' county='Palm Beach' d:count='23293' xmlns:d='http://www.democrat.org/' xmlns:r='http://www.republican.org/'/>"""

if __name__ == '__main__':
    test_main()
