########################################################################
# test/xslt/rt_20000515.py
# "Ron Ten-Hove" <rtenhove@forte.com>, by wondering why he doesn't get 
# the expected result from passing params to unnamed templates, exposes 
# a subtle gotcha.  15 May 2000

import os
import cStringIO
import unittest

from amara.lib import treecompare
from amara.test import test_main
from amara.test.xslt import xslt_test, filesource, stringsource

class test_xslt_params_in_unnamed_templates_rt_20000515(xslt_test):
    source = stringsource("""<?xml version="1.0"?>
<doc>
  <chapter name="The beginning">
    Alpha.
  </chapter>
</doc>
""")
    transform = stringsource("""<?xml version="1.0"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                version="1.0">
    <xsl:output indent="yes"/>

    <xsl:template match="/">
        <root>
            <xsl:apply-templates>
                <xsl:with-param name="param">List</xsl:with-param>
            </xsl:apply-templates>
        </root>
    </xsl:template>

    <xsl:template match="chapter">
      <xsl:param name="param">Unset</xsl:param>
      <chap>
        <xsl:attribute name="title"><xsl:value-of
select="@name"/></xsl:attribute>
        <xsl:attribute name="cat"><xsl:value-of
select="$param"/></xsl:attribute>
      </chap>
    </xsl:template>

    <xsl:template match="text()" />
</xsl:stylesheet>""")
    parameters = {}
    expected = """<?xml version='1.0' encoding='UTF-8'?>
<root>
  <chap title='The beginning' cat='Unset'/>
</root>"""


if __name__ == '__main__':
    test_main()
