# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class ExpressionEvaluationDetails(Model):
    """Evaluation details of policy language expressions.

    :param result: Evaluation result.
    :type result: str
    :param expression: Expression evaluated.
    :type expression: str
    :param path: Property path if the expression is a field or an alias.
    :type path: str
    :param expression_value: Value of the expression.
    :type expression_value: object
    :param target_value: Target value to be compared with the expression
     value.
    :type target_value: object
    :param operator: Operator to compare the expression value and the target
     value.
    :type operator: str
    """

    _attribute_map = {
        'result': {'key': 'result', 'type': 'str'},
        'expression': {'key': 'expression', 'type': 'str'},
        'path': {'key': 'path', 'type': 'str'},
        'expression_value': {'key': 'expressionValue', 'type': 'object'},
        'target_value': {'key': 'targetValue', 'type': 'object'},
        'operator': {'key': 'operator', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(ExpressionEvaluationDetails, self).__init__(**kwargs)
        self.result = kwargs.get('result', None)
        self.expression = kwargs.get('expression', None)
        self.path = kwargs.get('path', None)
        self.expression_value = kwargs.get('expression_value', None)
        self.target_value = kwargs.get('target_value', None)
        self.operator = kwargs.get('operator', None)
