# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.service_client import SDKClient
from msrest import Serializer, Deserializer

from azure.profiles import KnownProfiles, ProfileDefinition
from azure.profiles.multiapiclient import MultiApiClientMixin
from ._configuration import AzureDigitalTwinsManagementClientConfiguration



class AzureDigitalTwinsManagementClient(MultiApiClientMixin, SDKClient):
    """Azure Digital Twins Client for managing DigitalTwinsInstance

    This ready contains multiple API versions, to help you deal with all Azure clouds
    (Azure Stack, Azure Government, Azure China, etc.).
    By default, uses latest API version available on public Azure.
    For production, you should stick a particular api-version and/or profile.
    The profile sets a mapping between the operation group and an API version.
    The api-version parameter sets the default API version if the operation
    group is not described in the profile.

    :ivar config: Configuration for client.
    :vartype config: AzureDigitalTwinsManagementClientConfiguration

    :param credentials: Credentials needed for the client to connect to Azure.
    :type credentials: :mod:`A msrestazure Credentials
     object<msrestazure.azure_active_directory>`
    :param subscription_id: Subscription credentials which uniquely identify
     Microsoft Azure subscription. The subscription ID forms part of the URI
     for every service call.
    :type subscription_id: str
    :param str api_version: API version to use if no profile is provided, or if
     missing in profile.
    :param str base_url: Service URL
    :param profile: A profile definition, from KnownProfiles to dict.
    :type profile: azure.profiles.KnownProfiles
    """

    DEFAULT_API_VERSION = '2020-10-31'
    _PROFILE_TAG = "azure.mgmt.digitaltwins.AzureDigitalTwinsManagementClient"
    LATEST_PROFILE = ProfileDefinition({
        _PROFILE_TAG: {
            None: DEFAULT_API_VERSION,
        }},
        _PROFILE_TAG + " latest"
    )

    def __init__(self, credentials, subscription_id, api_version=None, base_url=None, profile=KnownProfiles.default):
        self.config = AzureDigitalTwinsManagementClientConfiguration(credentials, subscription_id, base_url)
        super(AzureDigitalTwinsManagementClient, self).__init__(
            credentials,
            self.config,
            api_version=api_version,
            profile=profile
        )

    @classmethod
    def _models_dict(cls, api_version):
        return {k: v for k, v in cls.models(api_version).__dict__.items() if isinstance(v, type)}

    @classmethod
    def models(cls, api_version=DEFAULT_API_VERSION):
        """Module depends on the API version:

           * 2020-03-01-preview: :mod:`v2020_03_01_preview.models<azure.mgmt.digitaltwins.v2020_03_01_preview.models>`
           * 2020-10-31: :mod:`v2020_10_31.models<azure.mgmt.digitaltwins.v2020_10_31.models>`
        """
        if api_version == '2020-03-01-preview':
            from .v2020_03_01_preview import models
            return models
        elif api_version == '2020-10-31':
            from .v2020_10_31 import models
            return models
        raise NotImplementedError("APIVersion {} is not available".format(api_version))

    @property
    def digital_twins(self):
        """Instance depends on the API version:

           * 2020-03-01-preview: :class:`DigitalTwinsOperations<azure.mgmt.digitaltwins.v2020_03_01_preview.operations.DigitalTwinsOperations>`
           * 2020-10-31: :class:`DigitalTwinsOperations<azure.mgmt.digitaltwins.v2020_10_31.operations.DigitalTwinsOperations>`
        """
        api_version = self._get_api_version('digital_twins')
        if api_version == '2020-03-01-preview':
            from .v2020_03_01_preview.operations import DigitalTwinsOperations as OperationClass
        elif api_version == '2020-10-31':
            from .v2020_10_31.operations import DigitalTwinsOperations as OperationClass
        else:
            raise NotImplementedError("APIVersion {} is not available".format(api_version))
        return OperationClass(self._client, self.config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)))

    @property
    def digital_twins_endpoint(self):
        """Instance depends on the API version:

           * 2020-03-01-preview: :class:`DigitalTwinsEndpointOperations<azure.mgmt.digitaltwins.v2020_03_01_preview.operations.DigitalTwinsEndpointOperations>`
           * 2020-10-31: :class:`DigitalTwinsEndpointOperations<azure.mgmt.digitaltwins.v2020_10_31.operations.DigitalTwinsEndpointOperations>`
        """
        api_version = self._get_api_version('digital_twins_endpoint')
        if api_version == '2020-03-01-preview':
            from .v2020_03_01_preview.operations import DigitalTwinsEndpointOperations as OperationClass
        elif api_version == '2020-10-31':
            from .v2020_10_31.operations import DigitalTwinsEndpointOperations as OperationClass
        else:
            raise NotImplementedError("APIVersion {} is not available".format(api_version))
        return OperationClass(self._client, self.config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)))

    @property
    def operations(self):
        """Instance depends on the API version:

           * 2020-03-01-preview: :class:`Operations<azure.mgmt.digitaltwins.v2020_03_01_preview.operations.Operations>`
           * 2020-10-31: :class:`Operations<azure.mgmt.digitaltwins.v2020_10_31.operations.Operations>`
        """
        api_version = self._get_api_version('operations')
        if api_version == '2020-03-01-preview':
            from .v2020_03_01_preview.operations import Operations as OperationClass
        elif api_version == '2020-10-31':
            from .v2020_10_31.operations import Operations as OperationClass
        else:
            raise NotImplementedError("APIVersion {} is not available".format(api_version))
        return OperationClass(self._client, self.config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)))
