/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.receivers.db;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Properties;
import javax.sql.DataSource;
import org.apache.log4j.receivers.db.ConnectionSourceSkeleton;
import org.apache.log4j.xml.DOMConfigurator;
import org.apache.log4j.xml.UnrecognizedElementHandler;
import org.w3c.dom.Element;

public class DataSourceConnectionSource
extends ConnectionSourceSkeleton
implements UnrecognizedElementHandler {
    private DataSource dataSource;

    public void activateOptions() {
        if (this.dataSource == null) {
            this.getLogger().warn("WARNING: No data source specified");
        } else {
            Connection connection = null;
            try {
                connection = this.getConnection();
            }
            catch (SQLException se) {
                this.getLogger().warn((Object)"Could not get a connection to discover the dialect to use.", se);
            }
            if (connection != null) {
                this.discoverConnnectionProperties();
            }
            if (!this.supportsGetGeneratedKeys() && this.getSQLDialectCode() == 0) {
                this.getLogger().warn("Connection does not support GetGeneratedKey method and could not discover the dialect.");
            }
        }
    }

    public Connection getConnection() throws SQLException {
        if (this.dataSource == null) {
            this.getLogger().error("WARNING: No data source specified");
            return null;
        }
        if (this.getUser() == null) {
            return this.dataSource.getConnection();
        }
        return this.dataSource.getConnection(this.getUser(), this.getPassword());
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public boolean parseUnrecognizedElement(Element element, Properties props) throws Exception {
        if ("dataSource".equals(element.getNodeName())) {
            Object instance = DOMConfigurator.parseElement(element, props, DataSource.class);
            if (instance instanceof DataSource) {
                this.setDataSource((DataSource)instance);
            }
            return true;
        }
        return false;
    }
}

