/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.proactive.scheduler.common;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.security.auth.Subject;
import org.objectweb.proactive.annotation.PublicAPI;
import org.ow2.proactive.authentication.UserData;
import org.ow2.proactive.db.SortParameter;
import org.ow2.proactive.permissions.RoleAdmin;
import org.ow2.proactive.permissions.RoleBasic;
import org.ow2.proactive.permissions.RoleRead;
import org.ow2.proactive.permissions.RoleWrite;
import org.ow2.proactive.permissions.ServiceUsingPermission;
import org.ow2.proactive.scheduler.common.JobDescriptor;
import org.ow2.proactive.scheduler.common.JobFilterCriteria;
import org.ow2.proactive.scheduler.common.JobSortParameter;
import org.ow2.proactive.scheduler.common.Page;
import org.ow2.proactive.scheduler.common.SchedulerEvent;
import org.ow2.proactive.scheduler.common.SchedulerEventListener;
import org.ow2.proactive.scheduler.common.SchedulerState;
import org.ow2.proactive.scheduler.common.SchedulerStatus;
import org.ow2.proactive.scheduler.common.SortSpecifierContainer;
import org.ow2.proactive.scheduler.common.TaskDescriptor;
import org.ow2.proactive.scheduler.common.ThirdPartyCredentials;
import org.ow2.proactive.scheduler.common.exception.ImageValidationException;
import org.ow2.proactive.scheduler.common.exception.JobAlreadyFinishedException;
import org.ow2.proactive.scheduler.common.exception.JobCreationException;
import org.ow2.proactive.scheduler.common.exception.JobValidationException;
import org.ow2.proactive.scheduler.common.exception.LabelConflictException;
import org.ow2.proactive.scheduler.common.exception.LabelNotFoundException;
import org.ow2.proactive.scheduler.common.exception.LabelValidationException;
import org.ow2.proactive.scheduler.common.exception.NotConnectedException;
import org.ow2.proactive.scheduler.common.exception.PermissionException;
import org.ow2.proactive.scheduler.common.exception.SchedulerException;
import org.ow2.proactive.scheduler.common.exception.SubmissionClosedException;
import org.ow2.proactive.scheduler.common.exception.UnknownJobException;
import org.ow2.proactive.scheduler.common.exception.UnknownTaskException;
import org.ow2.proactive.scheduler.common.job.CompletedJobsCount;
import org.ow2.proactive.scheduler.common.job.CompletedTasksCount;
import org.ow2.proactive.scheduler.common.job.FilteredStatistics;
import org.ow2.proactive.scheduler.common.job.FilteredTopWorkflow;
import org.ow2.proactive.scheduler.common.job.FilteredTopWorkflowsCumulatedCoreTime;
import org.ow2.proactive.scheduler.common.job.FilteredTopWorkflowsNumberOfNodes;
import org.ow2.proactive.scheduler.common.job.Job;
import org.ow2.proactive.scheduler.common.job.JobId;
import org.ow2.proactive.scheduler.common.job.JobIdDataAndError;
import org.ow2.proactive.scheduler.common.job.JobInfo;
import org.ow2.proactive.scheduler.common.job.JobLabelInfo;
import org.ow2.proactive.scheduler.common.job.JobPriority;
import org.ow2.proactive.scheduler.common.job.JobResult;
import org.ow2.proactive.scheduler.common.job.JobState;
import org.ow2.proactive.scheduler.common.job.JobVariable;
import org.ow2.proactive.scheduler.common.job.WorkflowDuration;
import org.ow2.proactive.scheduler.common.task.TaskId;
import org.ow2.proactive.scheduler.common.task.TaskResult;
import org.ow2.proactive.scheduler.common.task.TaskState;
import org.ow2.proactive.scheduler.common.task.TaskStatesPage;
import org.ow2.proactive.scheduler.common.task.TaskStatus;
import org.ow2.proactive.scheduler.common.usage.SchedulerUsage;
import org.ow2.proactive.scheduler.common.util.logforwarder.AppenderProvider;
import org.ow2.proactive.scheduler.job.SchedulerUserInfo;
import org.ow2.proactive.scheduler.signal.SignalApiException;

@PublicAPI
public interface Scheduler
extends SchedulerUsage,
ThirdPartyCredentials,
ServiceUsingPermission {
    @RoleBasic
    public boolean checkJobPermissionMethod(String var1, String var2) throws SchedulerException;

    @RoleBasic
    public List<String> checkJobsPermissionMethod(List<String> var1, String var2) throws SchedulerException;

    @RoleWrite
    public Set<String> addJobSignal(String var1, String var2, Map<String, String> var3) throws NotConnectedException, UnknownJobException, PermissionException, SignalApiException, JobValidationException;

    @RoleWrite
    public List<JobVariable> validateJobSignal(String var1, String var2, Map<String, String> var3) throws NotConnectedException, UnknownJobException, PermissionException, SignalApiException, JobValidationException;

    @RoleRead
    public List<String> getUserSpaceURIs() throws NotConnectedException, PermissionException;

    @RoleRead
    public List<String> getGlobalSpaceURIs() throws NotConnectedException, PermissionException;

    @RoleRead
    public JobResult getJobResult(JobId var1) throws NotConnectedException, PermissionException, UnknownJobException;

    @RoleRead
    public TaskResult getTaskResultFromIncarnation(JobId var1, String var2, int var3) throws NotConnectedException, UnknownJobException, UnknownTaskException, PermissionException;

    @RoleRead
    public List<TaskResult> getTaskResultAllIncarnations(JobId var1, String var2) throws NotConnectedException, UnknownJobException, UnknownTaskException, PermissionException;

    @RoleRead
    public List<TaskResult> getTaskResultAllIncarnations(String var1, String var2) throws NotConnectedException, UnknownJobException, UnknownTaskException, PermissionException;

    @RoleWrite
    public boolean killTask(JobId var1, String var2) throws NotConnectedException, UnknownJobException, UnknownTaskException, PermissionException;

    @RoleWrite
    public boolean restartTask(JobId var1, String var2, int var3) throws NotConnectedException, UnknownJobException, UnknownTaskException, PermissionException;

    @RoleWrite
    public boolean preemptTask(JobId var1, String var2, int var3) throws NotConnectedException, UnknownJobException, UnknownTaskException, PermissionException;

    @RoleWrite
    public boolean removeJob(JobId var1) throws NotConnectedException, UnknownJobException, PermissionException;

    @RoleWrite
    public boolean removeJobs(List<JobId> var1) throws NotConnectedException, PermissionException;

    @RoleWrite
    public boolean removeJobs(long var1) throws NotConnectedException, PermissionException;

    @RoleRead
    public void listenJobLogs(JobId var1, AppenderProvider var2) throws NotConnectedException, UnknownJobException, PermissionException;

    @RoleWrite
    public boolean killJob(JobId var1) throws NotConnectedException, UnknownJobException, PermissionException;

    @RoleWrite
    public boolean pauseJob(JobId var1) throws NotConnectedException, UnknownJobException, PermissionException;

    @RoleWrite
    public boolean resumeJob(JobId var1) throws NotConnectedException, UnknownJobException, PermissionException;

    @RoleWrite
    public void changeJobPriority(JobId var1, JobPriority var2) throws NotConnectedException, UnknownJobException, PermissionException, JobAlreadyFinishedException;

    @RoleAdmin
    public boolean changePolicy(String var1) throws NotConnectedException, PermissionException;

    @RoleAdmin
    public boolean start() throws NotConnectedException, PermissionException;

    @RoleAdmin
    public boolean stop() throws NotConnectedException, PermissionException;

    @RoleAdmin
    public boolean pause() throws NotConnectedException, PermissionException;

    @RoleAdmin
    public boolean freeze() throws NotConnectedException, PermissionException;

    @RoleAdmin
    public boolean resume() throws NotConnectedException, PermissionException;

    @RoleAdmin
    public boolean shutdown() throws NotConnectedException, PermissionException;

    @RoleAdmin
    public boolean kill() throws NotConnectedException, PermissionException;

    @RoleAdmin
    public boolean linkResourceManager(String var1) throws NotConnectedException, PermissionException;

    @RoleAdmin
    public boolean reloadPolicyConfiguration() throws NotConnectedException, PermissionException;

    @RoleWrite
    public JobId submit(Job var1) throws NotConnectedException, PermissionException, SubmissionClosedException, JobCreationException;

    @RoleWrite
    public List<JobIdDataAndError> submit(List<Job> var1) throws NotConnectedException;

    @RoleWrite
    public JobId reSubmit(JobId var1, Map<String, String> var2, Map<String, String> var3, String var4) throws NotConnectedException, UnknownJobException, PermissionException, JobCreationException, SubmissionClosedException;

    @RoleRead
    public JobResult getJobResult(String var1) throws NotConnectedException, PermissionException, UnknownJobException;

    @RoleRead
    public TaskResult getTaskResult(String var1, String var2) throws NotConnectedException, UnknownJobException, UnknownTaskException, PermissionException;

    @RoleRead
    public List<TaskResult> getTaskResultsByTag(JobId var1, String var2) throws NotConnectedException, UnknownJobException, PermissionException;

    @RoleRead
    public List<TaskResult> getTaskResultsByTag(String var1, String var2) throws NotConnectedException, UnknownJobException, PermissionException;

    @RoleRead
    public TaskResult getTaskResult(JobId var1, String var2) throws NotConnectedException, UnknownJobException, UnknownTaskException, PermissionException;

    @RoleRead
    public TaskResult getTaskResultFromIncarnation(String var1, String var2, int var3) throws NotConnectedException, UnknownJobException, UnknownTaskException, PermissionException;

    @RoleWrite
    public boolean removeJob(String var1) throws NotConnectedException, UnknownJobException, PermissionException;

    @RoleRead
    public void listenJobLogs(String var1, AppenderProvider var2) throws NotConnectedException, UnknownJobException, PermissionException;

    @RoleWrite
    public boolean killJob(String var1) throws NotConnectedException, UnknownJobException, PermissionException;

    @RoleWrite
    public boolean killJobs(List<String> var1) throws NotConnectedException, PermissionException;

    @RoleWrite
    public boolean killTask(String var1, String var2) throws NotConnectedException, UnknownJobException, UnknownTaskException, PermissionException;

    @RoleWrite
    public boolean restartTask(String var1, String var2, int var3) throws NotConnectedException, UnknownJobException, UnknownTaskException, PermissionException;

    @RoleWrite
    public boolean finishInErrorTask(String var1, String var2) throws NotConnectedException, UnknownJobException, UnknownTaskException, PermissionException;

    @RoleWrite
    public boolean restartInErrorTask(String var1, String var2) throws NotConnectedException, UnknownJobException, UnknownTaskException, PermissionException;

    @RoleWrite
    public void enableRemoteVisualization(String var1, String var2, String var3) throws NotConnectedException, PermissionException, UnknownJobException, UnknownTaskException;

    @RoleWrite
    public void registerService(String var1, int var2, boolean var3) throws NotConnectedException, PermissionException, UnknownJobException;

    @RoleWrite
    public void detachService(String var1, int var2) throws NotConnectedException, PermissionException, UnknownJobException;

    @RoleWrite
    public boolean preemptTask(String var1, String var2, int var3) throws NotConnectedException, UnknownJobException, UnknownTaskException, PermissionException;

    @RoleWrite
    public boolean pauseJob(String var1) throws NotConnectedException, UnknownJobException, PermissionException;

    @RoleWrite
    public boolean restartAllInErrorTasks(String var1) throws NotConnectedException, UnknownJobException, PermissionException;

    @RoleWrite
    public boolean resumeJob(String var1) throws NotConnectedException, UnknownJobException, PermissionException;

    @RoleWrite
    public void changeJobPriority(String var1, JobPriority var2) throws NotConnectedException, UnknownJobException, PermissionException, JobAlreadyFinishedException;

    @RoleRead
    public JobState getJobState(String var1) throws NotConnectedException, UnknownJobException, PermissionException;

    @RoleRead
    public SchedulerStatus getStatus() throws NotConnectedException, PermissionException;

    @RoleRead
    public JobState getJobState(JobId var1) throws NotConnectedException, UnknownJobException, PermissionException;

    @RoleRead
    public TaskState getTaskState(JobId var1, String var2) throws NotConnectedException, UnknownJobException, UnknownTaskException, PermissionException;

    @RoleRead
    public SchedulerState getState() throws NotConnectedException, PermissionException;

    @RoleRead
    public SchedulerState getState(boolean var1) throws NotConnectedException, PermissionException;

    @RoleRead
    public void addEventListener(SchedulerEventListener var1, boolean var2, SchedulerEvent ... var3) throws NotConnectedException, PermissionException;

    @RoleRead
    public SchedulerState addEventListener(SchedulerEventListener var1, boolean var2, boolean var3, SchedulerEvent ... var4) throws NotConnectedException, PermissionException;

    @RoleRead
    public void removeEventListener() throws NotConnectedException, PermissionException;

    @RoleBasic
    public void disconnect() throws NotConnectedException, PermissionException;

    @RoleBasic
    public boolean isConnected();

    @RoleRead
    public String getCurrentPolicy() throws NotConnectedException, PermissionException;

    @RoleAdmin
    public Map<JobId, JobDescriptor> getJobsToSchedule() throws NotConnectedException, PermissionException;

    @RoleAdmin
    public List<TaskDescriptor> getTasksToSchedule() throws NotConnectedException, PermissionException;

    @RoleBasic
    public void renewSession() throws NotConnectedException;

    @RoleRead
    public String getJobServerLogs(String var1) throws UnknownJobException, NotConnectedException, PermissionException;

    @RoleRead
    public String getTaskServerLogs(String var1, String var2) throws UnknownJobException, UnknownTaskException, NotConnectedException, PermissionException;

    @RoleRead
    public String getTaskServerLogsByTag(String var1, String var2) throws UnknownJobException, NotConnectedException, PermissionException;

    @RoleRead
    public Page<JobInfo> getJobs(int var1, int var2, JobFilterCriteria var3, List<SortParameter<JobSortParameter>> var4) throws NotConnectedException, PermissionException;

    @RoleRead
    public List<JobInfo> getJobsInfoList(List<String> var1) throws PermissionException, NotConnectedException;

    @RoleRead
    public List<SchedulerUserInfo> getUsers() throws NotConnectedException, PermissionException;

    @RoleAdmin
    public List<SchedulerUserInfo> getUsersWithJobs() throws NotConnectedException, PermissionException;

    @RoleRead
    public FilteredStatistics getFilteredStatistics(String var1, String var2, Boolean var3, long var4, long var6) throws NotConnectedException, PermissionException;

    @RoleRead
    public List<FilteredTopWorkflow> getTopWorkflowsWithIssues(int var1, String var2, String var3, Boolean var4, long var5, long var7) throws NotConnectedException, PermissionException;

    @RoleRead
    public List<FilteredTopWorkflowsCumulatedCoreTime> getTopWorkflowsCumulatedCoreTime(int var1, String var2, String var3, Boolean var4, long var5, long var7) throws NotConnectedException, PermissionException;

    @RoleRead
    public List<FilteredTopWorkflowsNumberOfNodes> getTopWorkflowsNumberOfNodes(int var1, String var2, String var3, boolean var4, long var5, long var7, boolean var9) throws NotConnectedException, PermissionException;

    @RoleRead
    public List<WorkflowDuration> getTopExecutionTimeWorkflows(int var1, String var2, String var3, Boolean var4, long var5, long var7) throws NotConnectedException, PermissionException;

    @RoleRead
    public List<WorkflowDuration> getTopPendingTimeWorkflows(int var1, String var2, String var3, Boolean var4, long var5, long var7) throws NotConnectedException, PermissionException;

    @RoleRead
    public Map<String, Integer> getSubmissionModeCount(String var1, String var2, Boolean var3, long var4, long var6) throws NotConnectedException, PermissionException;

    @RoleRead
    public CompletedJobsCount getCompletedJobs(Boolean var1, String var2, String var3, long var4, long var6, int var8) throws NotConnectedException, PermissionException;

    @RoleRead
    public CompletedTasksCount getCompletedTasks(Boolean var1, String var2, long var3, long var5, int var7) throws NotConnectedException, PermissionException;

    @RoleRead
    public Set<String> getSubmissionModeValues() throws NotConnectedException, PermissionException;

    @RoleRead
    public Page<TaskId> getTaskIds(String var1, long var2, long var4, boolean var6, Set<TaskStatus> var7, int var8, int var9) throws SchedulerException;

    @RoleRead
    public Page<TaskState> getTaskStates(String var1, long var2, long var4, boolean var6, Set<TaskStatus> var7, int var8, int var9, SortSpecifierContainer var10) throws SchedulerException;

    @RoleRead
    public JobInfo getJobInfo(String var1) throws SchedulerException;

    @RoleWrite
    public boolean changeStartAt(JobId var1, String var2) throws NotConnectedException, UnknownJobException, PermissionException;

    @RoleWrite
    public boolean changeStartAt(List<JobId> var1, String var2) throws NotConnectedException, UnknownJobException, PermissionException;

    @RoleRead
    public String getJobContent(JobId var1) throws SchedulerException;

    @RoleRead
    public Map<Object, Object> getPortalConfiguration() throws SchedulerException;

    @RoleBasic
    public String getCurrentUser() throws NotConnectedException;

    @RoleBasic
    public UserData getCurrentUserData() throws NotConnectedException;

    @RoleBasic
    public Subject getSubject() throws NotConnectedException;

    @RoleRead
    public Map<String, Object> getSchedulerProperties() throws SchedulerException;

    @RoleRead
    public TaskStatesPage getTaskPaginated(String var1, int var2, int var3) throws NotConnectedException, UnknownJobException, PermissionException;

    @RoleRead
    public TaskStatesPage getTaskPaginated(String var1, String var2, int var3, int var4) throws NotConnectedException, UnknownJobException, PermissionException;

    @RoleRead
    public List<TaskResult> getPreciousTaskResults(String var1) throws NotConnectedException, PermissionException, UnknownJobException;

    @RoleRead
    public Map<Long, Map<String, Serializable>> getJobResultMaps(List<String> var1) throws NotConnectedException, UnknownJobException, PermissionException;

    @RoleRead
    public Map<Long, List<String>> getPreciousTaskNames(List<String> var1) throws SchedulerException;

    @RoleBasic
    public Map<String, Map<String, Boolean>> checkJobsPermissionMethods(List<String> var1, List<String> var2) throws NotConnectedException, UnknownJobException;

    @RoleWrite
    public void addExternalEndpointUrl(String var1, String var2, String var3, String var4) throws NotConnectedException, PermissionException, UnknownJobException;

    @RoleWrite
    public void removeExternalEndpointUrl(String var1, String var2) throws NotConnectedException, PermissionException, UnknownJobException;

    @RoleBasic
    public List<JobLabelInfo> getLabels() throws NotConnectedException, PermissionException;

    @RoleAdmin
    public List<JobLabelInfo> createLabels(List<String> var1) throws NotConnectedException, PermissionException, LabelConflictException, LabelValidationException;

    @RoleAdmin
    public List<JobLabelInfo> setLabels(List<String> var1) throws NotConnectedException, PermissionException, LabelValidationException;

    @RoleAdmin
    public JobLabelInfo updateLabel(String var1, String var2) throws NotConnectedException, PermissionException, LabelConflictException, LabelNotFoundException, LabelValidationException;

    @RoleAdmin
    public void deleteLabel(String var1) throws NotConnectedException, PermissionException, LabelNotFoundException;

    @RoleWrite
    public void setLabelOnJobs(String var1, List<String> var2) throws NotConnectedException, PermissionException, LabelNotFoundException, UnknownJobException;

    @RoleWrite
    public void removeJobLabels(List<String> var1) throws NotConnectedException, PermissionException, UnknownJobException;

    @RoleAdmin
    public void updateLogo(byte[] var1) throws NotConnectedException, PermissionException, ImageValidationException;
}

