/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.proactive.scheduler.common.job.factories.spi.stax;

import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.ow2.proactive.scheduler.common.Scheduler;
import org.ow2.proactive.scheduler.common.SchedulerSpaceInterface;
import org.ow2.proactive.scheduler.common.exception.JobValidationException;
import org.ow2.proactive.scheduler.common.job.TaskFlowJob;
import org.ow2.proactive.scheduler.common.job.factories.Schemas;
import org.ow2.proactive.scheduler.common.job.factories.ValidationUtil;
import org.ow2.proactive.scheduler.common.job.factories.XMLTags;
import org.ow2.proactive.scheduler.common.job.factories.spi.JobValidatorService;

public class StaxJobValidatorServiceProvider
implements JobValidatorService {
    private XMLInputFactory xmlInputFactory = null;

    public StaxJobValidatorServiceProvider() {
        System.setProperty("javax.xml.stream.XMLInputFactory", "com.ctc.wstx.stax.WstxInputFactory");
        this.xmlInputFactory = XMLInputFactory.newInstance();
        this.xmlInputFactory.setProperty("javax.xml.stream.isCoalescing", Boolean.TRUE);
        this.xmlInputFactory.setProperty("javax.xml.stream.isReplacingEntityReferences", Boolean.TRUE);
        this.xmlInputFactory.setProperty("javax.xml.stream.isNamespaceAware", Boolean.TRUE);
        this.xmlInputFactory.setProperty("javax.xml.stream.supportDTD", Boolean.FALSE);
    }

    @Override
    public void validateJob(InputStream jobInputStream) throws JobValidationException {
        try {
            byte[] bytes = ValidationUtil.getInputStreamBytes(jobInputStream);
            try (ByteArrayInputStream jobInputStreamForSchema = new ByteArrayInputStream(bytes);){
                String findSchemaByNamespaceUsed = this.findSchemaByNamespaceUsed(jobInputStreamForSchema);
                InputStream schemaStream = this.getClass().getResourceAsStream(findSchemaByNamespaceUsed);
                try (ByteArrayInputStream jobInputStreamForValidation = new ByteArrayInputStream(bytes);){
                    ValidationUtil.validate(jobInputStreamForValidation, schemaStream);
                }
            }
        }
        catch (Exception e) {
            throw new JobValidationException(true, (Throwable)e);
        }
    }

    @Override
    public TaskFlowJob validateJob(TaskFlowJob job) {
        return job;
    }

    @Override
    public TaskFlowJob validateJob(TaskFlowJob job, Scheduler scheduler, SchedulerSpaceInterface space, String sessionId) {
        return job;
    }

    private String findSchemaByNamespaceUsed(InputStream jobInputStream) throws FileNotFoundException, XMLStreamException, JobValidationException {
        try (XMLStreamReader cursorRoot = this.xmlInputFactory.createXMLStreamReader(jobInputStream);){
            String namespace;
            while (cursorRoot.hasNext()) {
                namespace = this.advanceCursorAndFindSchema(cursorRoot);
                if (namespace == null) continue;
                String string = namespace;
                return string;
            }
            namespace = Schemas.SCHEMA_LATEST.getLocation();
            return namespace;
        }
    }

    private String advanceCursorAndFindSchema(XMLStreamReader cursorRoot) throws XMLStreamException {
        String current;
        int eventType = cursorRoot.next();
        if (eventType == 1 && XMLTags.JOB.matches(current = cursorRoot.getLocalName())) {
            String namespace = cursorRoot.getName().getNamespaceURI();
            return Schemas.getSchemaByNamespace(namespace).getLocation();
        }
        return null;
    }
}

