# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class RegionContract(Model):
    """Region profile.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar name: Region name.
    :vartype name: str
    :param is_master_region: whether Region is the master region.
    :type is_master_region: bool
    :param is_deleted: whether Region is deleted.
    :type is_deleted: bool
    """

    _validation = {
        'name': {'readonly': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'is_master_region': {'key': 'isMasterRegion', 'type': 'bool'},
        'is_deleted': {'key': 'isDeleted', 'type': 'bool'},
    }

    def __init__(self, **kwargs):
        super(RegionContract, self).__init__(**kwargs)
        self.name = None
        self.is_master_region = kwargs.get('is_master_region', None)
        self.is_deleted = kwargs.get('is_deleted', None)
