########################################################################
# test/xslt/jlc_20060225.py
# This is in response to bug 1438337
# (<https://sourceforge.net/tracker/index.php?func=detail&aid=1438337&group_id=39954&atid=428292>).
# We have some XPath test cases that provide coverage for the bug, but it's
# good to have an XSLT test case or two to deal with it as well.

import os
import cStringIO
import unittest

from amara.lib import treecompare
from amara.test import test_main
from amara.test.xslt import xslt_test, filesource, stringsource

class test_xslt_xpath_empty_nodeset_jlc_20060225(xslt_test):
    source = stringsource("""\
<doc><a b='1'/></doc>""")
    transform = stringsource("""\
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
  <xsl:template match="/doc">
    <output>
      <xsl:apply-templates
        select="a[@b = '1' and @b!=preceding-sibling::a/@b]"/>
    </output>
  </xsl:template>
  <xsl:template match="a">
    <got-one>!</got-one>
  </xsl:template>
</xsl:stylesheet>""")
    parameters = {}
    expected = """<?xml version="1.0" encoding="UTF-8"?>
<output/>"""

if __name__ == '__main__':
    test_main()
