########################################################################
# test/xslt/km_xmascracker.py
# Michael Kay's Christmas Cracker.
# See 

import os
import cStringIO
import unittest

from amara.lib import treecompare
from amara.test import test_main
from amara.test.xslt import xslt_test, filesource, stringsource

commonsource = stringsource("""<q>2</q>""")

class test_xslt_xmas_cracker_1_km_xmascracker(xslt_test):
    source = commonsource
    transform = stringsource("""<a xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xsl:version="1.0">
<xsl:value-of select="*******************"/>
</a>""")
    parameters = {}
    expected = """<?xml version='1.0' encoding='UTF-8'?>
<a>1024</a>"""

class test_xslt_xmas_cracker_1_km_xmascracker(xslt_test):
    source = commonsource
    transform = stringsource("""<a xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xsl:version="1.0">
<xsl:value-of select="* + * + * + * + * + * + * + * + * + *"/>
</a>""")
    parameters = {}
    expected = """<?xml version='1.0' encoding='UTF-8'?>
<a>20</a>"""

if __name__ == '__main__':
    test_main()
