########################################################################
# test/xslt/mb_20011105.py
# At the time of this writing, 4xslt was not correctly determining the
# string-value of a root node. Also, when pDomlette was being used,
# a traceback would be generated when referencing a root node in an
# attribute value template.

import os
import cStringIO
import unittest

from amara.lib import treecompare
from amara.test import test_main
from amara.test.xslt import xslt_test, filesource, stringsource

class test_xslt_x_namespace_copy_through_mb_20011105(xslt_test):
    source = stringsource("""\
<?xml version="1.0"?>
<foo><bar>hello</bar><baz> world</baz></foo>""")
    transform = stringsource("""\
<?xml version="1.0"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">

  <xsl:output method="xml" indent="no"/>

  <xsl:template match="/">
    <rootnode stringvalue="{.}"/>
  </xsl:template>

</xsl:stylesheet>""")
    parameters = {}
    expected = """<?xml version='1.0' encoding='UTF-8'?>
<rootnode stringvalue='hello world'/>"""

if __name__ == '__main__':
    test_main()
