########################################################################
# test/xslt/mb_20030223.py
# a pretty straightforward Muenchian grouping test

import os
import cStringIO
import unittest

from amara.lib import treecompare
from amara.test import test_main
from amara.test.xslt import xslt_test, filesource, stringsource

class test_xslt_grouping_mb_20030223(xslt_test):
    source = stringsource("""<skills>
    <skill mark="excellent" name="excellentskill"/>
    <skill mark="excellent" name="excellent skill"/>
    <skill mark="good" name="goodskill"/>
    <skill mark="good" name="goodskill"/>
    <skill mark="basic" name="basicskill"/>
    <skill mark="basic" name="basicskill"/>
    <skill mark="excellent" name="excellentskill"/>
    <skill mark="good" name="goodskill"/>
    <skill mark="basic" name="basicskill"/>
</skills>""")
    transform = stringsource("""<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet version="1.0"
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

  <xsl:output method="html" indent="yes"/>

  <xsl:key name="skills-by-mark" match="skill" use="@mark"/>
  <xsl:template match="skills">
    <table>
      <!-- process a set consisting of the first skill element for each mark -->
      <xsl:for-each select="skill[count(.|key('skills-by-mark',@mark)[1])=1]">
        <tr>
          <td><b><xsl:value-of select="concat(@mark,' skills:')"/></b></td>
          <td>
            <!-- process all skill elements having the current skill's mark -->
            <xsl:for-each select="key('skills-by-mark',@mark)">
              <xsl:value-of select="@name"/>
              <xsl:if test="position()!=last()"><br/></xsl:if>
            </xsl:for-each>
          </td>
        </tr>
      </xsl:for-each>
    </table>
  </xsl:template>

</xsl:stylesheet>""")
    parameters = {}
    expected = """<table>
  <tr>
    <td><b>excellent skills:</b></td>
    <td>excellentskill
      <br>excellent skill
      <br>excellentskill
    </td>
  </tr>
  <tr>
    <td><b>good skills:</b></td>
    <td>goodskill
      <br>goodskill
      <br>goodskill
    </td>
  </tr>
  <tr>
    <td><b>basic skills:</b></td>
    <td>basicskill
      <br>basicskill
      <br>basicskill
    </td>
  </tr>
</table>"""

if __name__ == '__main__':
    test_main()

