########################################################################
# test/xslt/tk_20001125.py
#Tamito KAJIYAMA <kajiyama@grad.sccs.chukyo-u.ac.jp> caught us forgetting 
# to encode comment and PI output

import os
import cStringIO
import unittest

from amara.lib import treecompare
from amara.test import test_main
from amara.test.xslt import xslt_test, filesource, stringsource

class test_xslt_test_encode_pi_and_comment_tk_20001125(xslt_test):
    source = stringsource("""\
<?xml version='1.0' encoding='iso-8859-1'?>
<doc>
<para>H\344agen-Dazs</para>
<note>H\344agen-Dazs</note>
</doc>""")
    transform = stringsource("""<?xml version="1.0"?>
<xsl:stylesheet version="1.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<xsl:output method="xml" encoding="iso-8859-1"/>

<xsl:template match="para">
<para><xsl:value-of select="."/></para>
</xsl:template>

<xsl:template match="note">
<xsl:comment><xsl:value-of select="."/></xsl:comment>
</xsl:template>

</xsl:stylesheet>""")
    parameters = {}
    expected = """<?xml version='1.0' encoding='iso-8859-1'?>\012\012<para>H\344agen-Dazs</para>\012<!--H\344agen-Dazs-->\012"""

if __name__ == '__main__':
    test_main()

