########################################################################
# test/xslt/evdv_20060904.py
# Bug reported by Eric van der Vlist on IRC

import os
import cStringIO
import unittest

from amara.lib import treecompare
from amara.test import test_main
from amara.test.xslt import xslt_test, filesource, stringsource

class test_xslt_dynamic_map_test_evdv_20060904(xslt_test):
    source = stringsource("""\
<?xml version="1.0" encoding="UTF-8"?>
<Invoice>
   <TotalAmount>10000</TotalAmount>
   <InvoiceRow>  
     <RowAmount>3000</RowAmount>
   </InvoiceRow>
   <InvoiceRow>  
     <RowAmount>7000</RowAmount>
   </InvoiceRow>
</Invoice>
""")
    transform = stringsource("""<?xml version='1.0' encoding='UTF-8'?>
<xsl:transform
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
  xmlns:dyn="http://exslt.org/dynamic"
  exclude-result-prefixes="dyn"
  version="1.0"
>

  <xsl:template match="Invoice">
    <result>
      <xsl:value-of select="sum(dyn:map(InvoiceRow/RowAmount, 'string(.)'))"/>
    </result>
  </xsl:template>

</xsl:transform>
""")
    parameters = {}
    expected = '<?xml version="1.0" encoding="UTF-8"?>\n<result>10000</result>'

if __name__ == '__main__':
    test_main()



