# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class ChaosReport(Model):
    """Contains detailed Chaos report.
    .

    :param chaos_parameters: Defines all the parameters to configure a Chaos
     run.
    :type chaos_parameters: ~azure.servicefabric.models.ChaosParameters
    :param status: Current status of the Chaos run.
     . Possible values include: 'Invalid', 'Running', 'Stopped'
    :type status: str or ~azure.servicefabric.models.Status
    :param continuation_token: The continuation token parameter is used to
     obtain next set of results. The continuation token is included in the
     response of the API when the results from the system do not fit in a
     single response. When this value is passed to the next API call, the API
     returns next set of results. If there are no further results then the
     continuation token is not included in the response.
    :type continuation_token: str
    :param history: List of ChaosEvent's that meet the user-supplied criteria.
    :type history: list[~azure.servicefabric.models.ChaosEventWrapper]
    """

    _attribute_map = {
        'chaos_parameters': {'key': 'ChaosParameters', 'type': 'ChaosParameters'},
        'status': {'key': 'Status', 'type': 'str'},
        'continuation_token': {'key': 'ContinuationToken', 'type': 'str'},
        'history': {'key': 'History', 'type': '[ChaosEventWrapper]'},
    }

    def __init__(self, chaos_parameters=None, status=None, continuation_token=None, history=None):
        super(ChaosReport, self).__init__()
        self.chaos_parameters = chaos_parameters
        self.status = status
        self.continuation_token = continuation_token
        self.history = history
