# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from .property_batch_operation import PropertyBatchOperation


class CheckValuePropertyBatchOperation(PropertyBatchOperation):
    """Represents a PropertyBatchOperation that compares the value of the property
    with the expected value.
    The CheckValuePropertyBatchOperation is generally used as a precondition
    for the write operations in the batch.
    Note that if one PropertyBatchOperation in a PropertyBatch fails,
    the entire batch fails and cannot be committed in a transactional manner.
    .

    :param property_name: The name of the Service Fabric property.
    :type property_name: str
    :param kind: Constant filled by server.
    :type kind: str
    :param value: The expected property value.
    :type value: ~azure.servicefabric.models.PropertyValue
    """

    _validation = {
        'property_name': {'required': True},
        'kind': {'required': True},
        'value': {'required': True},
    }

    _attribute_map = {
        'property_name': {'key': 'PropertyName', 'type': 'str'},
        'kind': {'key': 'Kind', 'type': 'str'},
        'value': {'key': 'Value', 'type': 'PropertyValue'},
    }

    def __init__(self, property_name, value):
        super(CheckValuePropertyBatchOperation, self).__init__(property_name=property_name)
        self.value = value
        self.kind = 'CheckValue'
