# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from .deployed_service_replica_info import DeployedServiceReplicaInfo


class DeployedStatefulServiceReplicaInfo(DeployedServiceReplicaInfo):
    """Information about a stateful service replica deployed on a node.

    :param service_name: The full name of the service with 'fabric:' URI
     scheme.
    :type service_name: str
    :param service_type_name: Name of the service type as specified in the
     service manifest.
    :type service_type_name: str
    :param service_manifest_name: The name of the service manifest in which
     this service type is defined.
    :type service_manifest_name: str
    :param code_package_name: The name of the code package that hosts this
     replica.
    :type code_package_name: str
    :param partition_id: An internal ID used by Service Fabric to uniquely
     identify a partition. This is a randomly generated GUID when the service
     was created. The partition id is unique and does not change for the
     lifetime of the service. If the same service was deleted and recreated the
     ids of its partitions would be different.
    :type partition_id: str
    :param replica_status: The status of a replica of a service. Possible
     values are following.
     -Invalid - Indicates the replica status is invalid. All Service Fabric
     enumerations have the invalid type. The value is zero.
     -InBuild - The replica is being built. This means that a primary replica
     is seeding this replica. The value is 1.
     -Standby - The replica is in standby. The value is 2.
     -Ready - The replica is ready. The value is 3.
     -Down - The replica is down. The value is 4.
     -Dropped - Replica is dropped. This means that the replica has been
     removed from the replica set. If it is persisted, its state has been
     deleted. The value is 5.
     . Possible values include: 'Invalid', 'InBuild', 'Standby', 'Ready',
     'Down', 'Dropped'
    :type replica_status: str or ~azure.servicefabric.models.enum
    :param address: The last address returned by the replica in Open or
     ChangeRole.
    :type address: str
    :param service_package_activation_id: The ActivationId of a deployed
     service package. If ServicePackageActivationMode specified at the time of
     creating the service
     is 'SharedProcess' (or if it is not specified, in which case it defaults
     to 'SharedProcess'), then value of ServicePackageActivationId
     is always an empty string.
    :type service_package_activation_id: str
    :param host_process_id: Host process id of the process that is hosting the
     replica. This will be zero if the replica is down. In hyper-v containers
     this host process id will be from different kernel.
    :type host_process_id: str
    :param service_kind: Constant filled by server.
    :type service_kind: str
    :param replica_id: Id of a stateful service replica. ReplicaId is used by
     Service Fabric to uniquely identify a replica of a partition. It is unique
     within a partition and does not change for the lifetime of the replica. If
     a replica gets dropped and another replica gets created on the same node
     for the same partition, it will get a different value for the id.
     Sometimes the id of a stateless service instance is also referred as a
     replica id.
    :type replica_id: str
    :param replica_role: The role of a replica of a stateful service. Possible
     values include: 'Unknown', 'None', 'Primary', 'IdleSecondary',
     'ActiveSecondary'
    :type replica_role: str or ~azure.servicefabric.models.ReplicaRole
    :param reconfiguration_information: Information about current
     reconfiguration like phase, type, previous configuration role of replica
     and reconfiguration start date time.
    :type reconfiguration_information:
     ~azure.servicefabric.models.ReconfigurationInformation
    """

    _validation = {
        'service_kind': {'required': True},
    }

    _attribute_map = {
        'service_name': {'key': 'ServiceName', 'type': 'str'},
        'service_type_name': {'key': 'ServiceTypeName', 'type': 'str'},
        'service_manifest_name': {'key': 'ServiceManifestName', 'type': 'str'},
        'code_package_name': {'key': 'CodePackageName', 'type': 'str'},
        'partition_id': {'key': 'PartitionId', 'type': 'str'},
        'replica_status': {'key': 'ReplicaStatus', 'type': 'str'},
        'address': {'key': 'Address', 'type': 'str'},
        'service_package_activation_id': {'key': 'ServicePackageActivationId', 'type': 'str'},
        'host_process_id': {'key': 'HostProcessId', 'type': 'str'},
        'service_kind': {'key': 'ServiceKind', 'type': 'str'},
        'replica_id': {'key': 'ReplicaId', 'type': 'str'},
        'replica_role': {'key': 'ReplicaRole', 'type': 'str'},
        'reconfiguration_information': {'key': 'ReconfigurationInformation', 'type': 'ReconfigurationInformation'},
    }

    def __init__(self, service_name=None, service_type_name=None, service_manifest_name=None, code_package_name=None, partition_id=None, replica_status=None, address=None, service_package_activation_id=None, host_process_id=None, replica_id=None, replica_role=None, reconfiguration_information=None):
        super(DeployedStatefulServiceReplicaInfo, self).__init__(service_name=service_name, service_type_name=service_type_name, service_manifest_name=service_manifest_name, code_package_name=code_package_name, partition_id=partition_id, replica_status=replica_status, address=address, service_package_activation_id=service_package_activation_id, host_process_id=host_process_id)
        self.replica_id = replica_id
        self.replica_role = replica_role
        self.reconfiguration_information = reconfiguration_information
        self.service_kind = 'Stateful'
