# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class HealthStatistics(Model):
    """The health statistics of an entity, returned as part of the health query
    result when the query description is configured to include statistics.
    The statistics include health state counts for all children types of the
    current entity.
    For example, for cluster, the health statistics include health state counts
    for nodes, applications, services, partitions, replicas, deployed
    applications and deployed service packages.
    For partition, the health statistics include health counts for replicas.
    .

    :param health_state_count_list: List of health state counts per entity
     kind, which keeps track of how many children of the queried entity are in
     Ok, Warning and Error state.
    :type health_state_count_list:
     list[~azure.servicefabric.models.EntityKindHealthStateCount]
    """

    _attribute_map = {
        'health_state_count_list': {'key': 'HealthStateCountList', 'type': '[EntityKindHealthStateCount]'},
    }

    def __init__(self, health_state_count_list=None):
        super(HealthStatistics, self).__init__()
        self.health_state_count_list = health_state_count_list
