# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from .health_evaluation import HealthEvaluation


class ServicesHealthEvaluation(HealthEvaluation):
    """Represents health evaluation for services of a certain service type
    belonging to an application, containing health evaluations for each
    unhealthy service that impacted current aggregated health state. Can be
    returned when evaluating application health and the aggregated health state
    is either Error or Warning.

    :param aggregated_health_state: The health state of a Service Fabric
     entity such as Cluster, Node, Application, Service, Partition, Replica
     etc. Possible values include: 'Invalid', 'Ok', 'Warning', 'Error',
     'Unknown'
    :type aggregated_health_state: str or
     ~azure.servicefabric.models.HealthState
    :param description: Description of the health evaluation, which represents
     a summary of the evaluation process.
    :type description: str
    :param kind: Constant filled by server.
    :type kind: str
    :param service_type_name: Name of the service type of the services.
    :type service_type_name: str
    :param max_percent_unhealthy_services: Maximum allowed percentage of
     unhealthy services from the ServiceTypeHealthPolicy.
    :type max_percent_unhealthy_services: int
    :param total_count: Total number of services of the current service type
     in the application from the health store.
    :type total_count: long
    :param unhealthy_evaluations: List of unhealthy evaluations that led to
     the aggregated health state. Includes all the unhealthy
     ServiceHealthEvaluation that impacted the aggregated health.
    :type unhealthy_evaluations:
     list[~azure.servicefabric.models.HealthEvaluationWrapper]
    """

    _validation = {
        'kind': {'required': True},
    }

    _attribute_map = {
        'aggregated_health_state': {'key': 'AggregatedHealthState', 'type': 'str'},
        'description': {'key': 'Description', 'type': 'str'},
        'kind': {'key': 'Kind', 'type': 'str'},
        'service_type_name': {'key': 'ServiceTypeName', 'type': 'str'},
        'max_percent_unhealthy_services': {'key': 'MaxPercentUnhealthyServices', 'type': 'int'},
        'total_count': {'key': 'TotalCount', 'type': 'long'},
        'unhealthy_evaluations': {'key': 'UnhealthyEvaluations', 'type': '[HealthEvaluationWrapper]'},
    }

    def __init__(self, aggregated_health_state=None, description=None, service_type_name=None, max_percent_unhealthy_services=None, total_count=None, unhealthy_evaluations=None):
        super(ServicesHealthEvaluation, self).__init__(aggregated_health_state=aggregated_health_state, description=description)
        self.service_type_name = service_type_name
        self.max_percent_unhealthy_services = max_percent_unhealthy_services
        self.total_count = total_count
        self.unhealthy_evaluations = unhealthy_evaluations
        self.kind = 'Services'
