/*
 * Decompiled with CFR 0.152.
 */
package be.re.css;

import be.re.css.BlockContainerFilter;
import be.re.css.CenterFilter;
import be.re.css.Constants;
import be.re.css.DisplayNonePropagator;
import be.re.css.FirstLetterFilter;
import be.re.css.FootnoteFilter;
import be.re.css.ForeignFilter;
import be.re.css.InvalidPropertyFilter;
import be.re.css.LengthAdjustFilter;
import be.re.css.LinkFilter;
import be.re.css.ListImageLabelFilter;
import be.re.css.MarkerFilter;
import be.re.css.NormalizeTableFilter;
import be.re.css.Property;
import be.re.css.WidthAndMarginsFilter;
import be.re.css.WrapperFilter;
import be.re.css.XHTMLAttributeTranslationFilter;
import be.re.xml.sax.FilterOfFilters;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.stream.StreamSource;
import org.w3c.css.sac.AttributeCondition;
import org.w3c.css.sac.CSSException;
import org.w3c.css.sac.CombinatorCondition;
import org.w3c.css.sac.Condition;
import org.w3c.css.sac.ConditionalSelector;
import org.w3c.css.sac.ContentCondition;
import org.w3c.css.sac.DescendantSelector;
import org.w3c.css.sac.LangCondition;
import org.w3c.css.sac.LexicalUnit;
import org.w3c.css.sac.NegativeCondition;
import org.w3c.css.sac.NegativeSelector;
import org.w3c.css.sac.Parser;
import org.w3c.css.sac.PositionalCondition;
import org.w3c.css.sac.Selector;
import org.w3c.css.sac.SiblingSelector;
import org.xml.sax.Attributes;
import org.xml.sax.XMLFilter;
import org.xml.sax.helpers.AttributesImpl;
import org.xml.sax.helpers.XMLFilterImpl;

class Util {
    private static final String[] FOOTNOTE_NUMBERS = new String[]{"*", "\u2020", "\u2021", "\u00a7", "||", "\u00b6", "#", "**", "\u2020\u2020", "\u2021\u2021", "\u00a7\u00a7"};
    private static final Set INHERITED = new HashSet<String>(Arrays.asList("azimuth", "border-collapse", "border-spacing", "caption-size", "color", "cursor", "direction", "elevation", "empty-cells", "font", "font-family", "font-size", "font-stretch", "font-style", "font-variant", "font-weight", "hyphenate", "leader-alignment", "leader-length", "leader-pattern", "leader-pattern-width", "letter-spacing", "line-height", "list-style", "list-style-image", "list-style-position", "list-style-type", "orientation", "orphans", "page", "page-break-inside", "pitch", "pitch-range", "quotes", "richness", "rule-style", "rule-thickness", "speak", "speak-header", "speak-numeral", "speak-punctuation", "speech-rate", "stress", "text-align", "text-indent", "text-transform", "voice-family", "volume", "white-space", "widows", "word-spacing"));
    private static Class sacParserClass = null;

    Util() {
    }

    static String conditionText(Condition condition) {
        switch (condition.getConditionType()) {
            case 0: {
                return "(and: " + Util.conditionText(((CombinatorCondition)condition).getFirstCondition()) + " " + Util.conditionText(((CombinatorCondition)condition).getSecondCondition()) + ")";
            }
            case 4: {
                return "(attribute: (" + ((AttributeCondition)condition).getNamespaceURI() + ") (" + ((AttributeCondition)condition).getLocalName() + ") (" + ((AttributeCondition)condition).getSpecified() + ") (" + ((AttributeCondition)condition).getValue() + "))";
            }
            case 8: {
                return "(hyphen: (" + ((AttributeCondition)condition).getNamespaceURI() + ") (" + ((AttributeCondition)condition).getLocalName() + ") (" + ((AttributeCondition)condition).getSpecified() + ") (" + ((AttributeCondition)condition).getValue() + "))";
            }
            case 9: {
                return "(class: (" + ((AttributeCondition)condition).getNamespaceURI() + ") (" + ((AttributeCondition)condition).getLocalName() + ") (" + ((AttributeCondition)condition).getSpecified() + ") (" + ((AttributeCondition)condition).getValue() + "))";
            }
            case 13: {
                return "(content: " + ((ContentCondition)condition).getData() + ")";
            }
            case 5: {
                return "(id: (" + ((AttributeCondition)condition).getNamespaceURI() + ") (" + ((AttributeCondition)condition).getLocalName() + ") (" + ((AttributeCondition)condition).getSpecified() + ") (" + ((AttributeCondition)condition).getValue() + "))";
            }
            case 6: {
                return "(lang: " + ((LangCondition)condition).getLang() + ")";
            }
            case 2: {
                return "(negative: " + Util.conditionText(((NegativeCondition)condition).getCondition()) + ")";
            }
            case 7: {
                return "(one of: (" + ((AttributeCondition)condition).getNamespaceURI() + ") (" + ((AttributeCondition)condition).getLocalName() + ") (" + ((AttributeCondition)condition).getSpecified() + ") (" + ((AttributeCondition)condition).getValue() + "))";
            }
            case 11: {
                return "(only child)";
            }
            case 12: {
                return "(only type)";
            }
            case 1: {
                return "(or: " + Util.conditionText(((CombinatorCondition)condition).getFirstCondition()) + " " + Util.conditionText(((CombinatorCondition)condition).getSecondCondition()) + ")";
            }
            case 3: {
                return "(positional: (" + ((PositionalCondition)condition).getPosition() + ") (" + ((PositionalCondition)condition).getType() + ") (" + ((PositionalCondition)condition).getTypeNode() + "))";
            }
            case 10: {
                return "(pseudo class: (" + ((AttributeCondition)condition).getNamespaceURI() + ") (" + ((AttributeCondition)condition).getLocalName() + ") (" + ((AttributeCondition)condition).getSpecified() + ") (" + ((AttributeCondition)condition).getValue() + "))";
            }
        }
        return "(unknown)";
    }

    private static String convertFloat(float value) {
        return new DecimalFormat("####0.0####").format(value);
    }

    static void copyAttribute(Attributes from, AttributesImpl to, String namespaceURI, String localName) {
        int index = from.getIndex(namespaceURI, localName);
        if (index != -1) {
            to.addAttribute(namespaceURI, localName, from.getQName(index), from.getType(index), from.getValue(index));
        }
    }

    static PostProjectionFilter createPostProjectionFilter(URL baseUrl, Map userAgentParameters, boolean debug) {
        final LinkFilter linkFilter = new LinkFilter(baseUrl);
        final FilterOfFilters filter = new FilterOfFilters(new XMLFilter[]{new InvalidPropertyFilter(), new WrapperFilter(), new DisplayNonePropagator(), new ForeignFilter(), new FirstLetterFilter(), userAgentParameters != null && userAgentParameters.get("rule-thickness") != null ? new XHTMLAttributeTranslationFilter((String)userAgentParameters.get("rule-thickness")) : new XHTMLAttributeTranslationFilter(), new NormalizeTableFilter(), new CenterFilter(), new LengthAdjustFilter(), new WidthAndMarginsFilter(), new MarkerFilter(), linkFilter, new FootnoteFilter(), new BlockContainerFilter(), new ListImageLabelFilter()}, debug);
        return new PostProjectionFilter(){

            public XMLFilterImpl getFilter() {
                return filter;
            }

            public void setBaseUrl(URL url) {
                linkFilter.setBaseUrl(url);
            }
        };
    }

    static XMLFilter createPreprocessorFilter(URL[] preprocessors, XMLFilter parent) throws TransformerConfigurationException {
        SAXTransformerFactory factory = be.re.xml.sax.Util.newSAXTransformerFactory();
        XMLFilter result = parent;
        for (int i = 0; i < preprocessors.length; ++i) {
            XMLFilter transformer = factory.newXMLFilter(new StreamSource(preprocessors[i].toString()));
            transformer.setParent(result);
            result = transformer;
        }
        return result;
    }

    static URL createUrl(String s) throws MalformedURLException {
        return be.re.net.Util.isUrl(s) ? new URL(s) : be.re.net.Util.fileToUrl(new File(s));
    }

    static URL[] createUrls(String s) throws MalformedURLException {
        ArrayList<URL> result = new ArrayList<URL>();
        StringTokenizer tokenizer = new StringTokenizer(s, ",");
        while (tokenizer.hasMoreTokens()) {
            result.add(Util.createUrl(tokenizer.nextToken()));
        }
        return result.toArray(new URL[0]);
    }

    static String getIndirectType(Attributes attributes, String property) {
        int index;
        String value = attributes.getValue(Constants.CSS, property);
        int n = index = value != null ? value.lastIndexOf(124) : -1;
        return value != null ? (index != -1 ? attributes.getType(value.substring(0, index), value.substring(index + 1)) : attributes.getType(value)) : null;
    }

    static String getIndirectValue(Attributes attributes, String property) {
        int index;
        String value = attributes.getValue(Constants.CSS, property);
        int n = index = value != null ? value.lastIndexOf(124) : -1;
        return value != null ? (index != -1 ? attributes.getValue(value.substring(0, index), value.substring(index + 1)) : attributes.getValue(value)) : null;
    }

    static Selector getLastSelector(Selector selector) {
        Selector[] chain = Util.getSelectorChain(selector);
        return chain[chain.length - 1];
    }

    static Parser getSacParser() throws CSSException {
        try {
            return (Parser)Util.getSacParserClass().newInstance();
        }
        catch (Exception e) {
            if (e instanceof CSSException) {
                throw (CSSException)e;
            }
            throw new CSSException(e);
        }
    }

    private static Class getSacParserClass() throws Exception {
        if (sacParserClass == null) {
            String cls = be.re.util.Util.getSystemProperty("org.w3c.css.sac.parser");
            if (cls == null) {
                throw new CSSException("No value for org.w3c.css.sac.parser");
            }
            sacParserClass = Class.forName(cls);
        }
        return sacParserClass;
    }

    static Selector[] getSelectorChain(Selector selector) {
        List result = Util.getSelectorChainList(selector);
        return result.toArray(new Selector[result.size()]);
    }

    private static List getSelectorChainList(Selector selector) {
        List<Selector> result;
        switch (selector.getSelectorType()) {
            case 10: 
            case 11: {
                result = Util.getSelectorChainList(((DescendantSelector)selector).getAncestorSelector());
                result.add(selector);
                result.addAll(Util.getSelectorChainList(((DescendantSelector)selector).getSimpleSelector()));
                break;
            }
            case 0: {
                result = new ArrayList();
                result.add(selector);
                result.addAll(Util.getSelectorChainList(((ConditionalSelector)selector).getSimpleSelector()));
                break;
            }
            case 12: {
                result = Util.getSelectorChainList(((SiblingSelector)selector).getSelector());
                result.add(selector);
                result.addAll(Util.getSelectorChainList(((SiblingSelector)selector).getSiblingSelector()));
                break;
            }
            case 3: {
                result = new ArrayList();
                result.add(selector);
                result.addAll(Util.getSelectorChainList(((NegativeSelector)selector).getSimpleSelector()));
                break;
            }
            default: {
                result = new ArrayList();
                result.add(selector);
            }
        }
        return result;
    }

    static boolean inArray(String[] array, String object) {
        for (int i = 0; i < array.length; ++i) {
            if ((array[i].charAt(array[i].length() - 1) != '*' || !object.startsWith(array[i].substring(0, array[i].length() - 1))) && !array[i].equals(object)) continue;
            return true;
        }
        return false;
    }

    static int indexOf(Object[] array, Object object) {
        for (int i = 0; i < array.length; ++i) {
            if (!array[i].equals(object)) continue;
            return i;
        }
        return -1;
    }

    static boolean isInherited(String property) {
        return INHERITED.contains(property);
    }

    static boolean isWhitespace(char[] ch, int start, int length) {
        for (int i = start; i < ch.length && i < start + length; ++i) {
            if (Character.isWhitespace(ch[i])) continue;
            return false;
        }
        return true;
    }

    static boolean isZeroLength(String value) {
        return Util.inArray(new String[]{"0", "0pt", "0px", "0pc", "0mm", "0cm", "0in", "0em"}, value);
    }

    static LexicalUnit[] lexicalUnitArray(LexicalUnit unit) {
        ArrayList<LexicalUnit> result = new ArrayList<LexicalUnit>();
        for (LexicalUnit i = unit; i != null; i = i.getNextLexicalUnit()) {
            result.add(i);
        }
        return result.toArray(new LexicalUnit[result.size()]);
    }

    static String lexicalUnitAtom(LexicalUnit unit, URL baseUrl) {
        return Util.lexicalUnitAtom(unit, false, baseUrl);
    }

    private static String lexicalUnitAtom(LexicalUnit unit, boolean identifiersToLower, URL baseUrl) {
        switch (unit.getLexicalUnitType()) {
            case 37: {
                return "attr(" + unit.getStringValue().toLowerCase() + ")";
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 33: 
            case 34: 
            case 42: {
                return (Util.convertFloat(unit.getFloatValue()) + unit.getDimensionUnitText()).toLowerCase();
            }
            case 14: {
                return Util.convertFloat(unit.getFloatValue());
            }
            case 25: 
            case 26: 
            case 38: 
            case 41: {
                return unit.getFunctionName().toLowerCase() + "(" + (unit.getParameters() != null ? Util.lexicalUnitChain(unit.getParameters(), identifiersToLower, baseUrl) : "") + ")";
            }
            case 35: {
                return identifiersToLower ? unit.getStringValue().toLowerCase() : unit.getStringValue();
            }
            case 12: {
                return "inherit";
            }
            case 13: {
                return String.valueOf(unit.getIntegerValue());
            }
            case 0: {
                return ",";
            }
            case 6: {
                return "^";
            }
            case 10: {
                return ">=";
            }
            case 8: {
                return ">";
            }
            case 9: {
                return "<=";
            }
            case 7: {
                return "<";
            }
            case 2: {
                return "-";
            }
            case 5: {
                return "%";
            }
            case 3: {
                return "*";
            }
            case 1: {
                return "+";
            }
            case 4: {
                return "/";
            }
            case 11: {
                return "~";
            }
            case 27: {
                return "rgb(" + Util.lexicalUnitChain(unit.getParameters(), identifiersToLower, baseUrl) + ")";
            }
            case 36: {
                return unit.getStringValue();
            }
            case 24: {
                try {
                    return "url(" + (baseUrl != null ? new URL(baseUrl, unit.getStringValue()).toString() : unit.getStringValue()) + ")";
                }
                catch (MalformedURLException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        return "";
    }

    static String lexicalUnitAtomLower(LexicalUnit unit, URL baseUrl) {
        return Util.lexicalUnitAtom(unit, baseUrl).toLowerCase();
    }

    static String[] lexicalUnitAtoms(LexicalUnit unit, URL baseUrl) {
        return Util.lexicalUnitAtoms(unit, false, baseUrl);
    }

    private static String[] lexicalUnitAtoms(LexicalUnit unit, boolean lower, URL baseUrl) {
        LexicalUnit[] values = Util.lexicalUnitArray(unit);
        String[] result = new String[values.length];
        for (int i = 0; i < values.length; ++i) {
            result[i] = lower ? Util.lexicalUnitAtomLower(values[i], baseUrl) : Util.lexicalUnitAtom(values[i], baseUrl);
        }
        return result;
    }

    static String[] lexicalUnitAtomsLower(LexicalUnit unit, URL baseUrl) {
        return Util.lexicalUnitAtoms(unit, true, baseUrl);
    }

    private static String lexicalUnitChain(LexicalUnit unit, boolean identifiersToLower, URL baseUrl) {
        return Util.lexicalUnitAtom(unit, identifiersToLower, baseUrl) + (unit.getNextLexicalUnit() != null ? " " + Util.lexicalUnitChain(unit.getNextLexicalUnit(), identifiersToLower, baseUrl) : "");
    }

    static String lexicalUnitToString(LexicalUnit unit, boolean identifiersToLower, URL baseUrl) {
        return Util.lexicalUnitChain(unit, identifiersToLower, baseUrl);
    }

    static Attributes mergeAttributes(Attributes from, Attributes into) {
        return Util.mergeAttributes(from, into, new String[0], false);
    }

    static Attributes mergeAttributes(Attributes from, Attributes into, String[] subset, boolean include) {
        AttributesImpl result = new AttributesImpl(into);
        for (int i = 0; i < from.getLength(); ++i) {
            if (into.getIndex(from.getURI(i), from.getLocalName(i)) != -1 || (include || Util.inArray(subset, from.getLocalName(i))) && (!include || !Util.inArray(subset, from.getLocalName(i)))) continue;
            result.addAttribute(from.getURI(i), from.getLocalName(i), from.getQName(i), from.getType(i), from.getValue(i));
        }
        return result;
    }

    private static String processFontFamily(String value) {
        if ((value = value.trim()).indexOf(32) == -1 || value.charAt(0) == '\'' && value.charAt(value.length() - 1) == '\'' || value.charAt(0) == '\"' && value.charAt(value.length() - 1) == '\"') {
            return value;
        }
        String result = "";
        StringTokenizer tokenizer = new StringTokenizer(value, ",");
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken().trim();
            result = result + (result.equals("") ? "" : ", ") + (token.indexOf(32) != -1 ? "'" + token + "'" : token);
        }
        return result;
    }

    static void removeAttribute(AttributesImpl atts, String namespaceURI, String localName) {
        int index = atts.getIndex(namespaceURI, localName);
        if (index != -1) {
            atts.removeAttribute(index);
        }
    }

    static void setAttribute(AttributesImpl attributes, String namespaceURI, String localName, String qName, String value) {
        int index = attributes.getIndex(namespaceURI, localName);
        if (index == -1) {
            attributes.addAttribute(namespaceURI, localName, qName, "CDATA", value);
        } else {
            attributes.setAttribute(index, namespaceURI, localName, qName, "CDATA", value);
        }
    }

    static void setCSSAttribute(AttributesImpl attributes, Property property, int specificity) {
        String value;
        String propertyName = property.getName();
        if (!"content".equals(propertyName) && property.getLexicalUnit() != null && property.getLexicalUnit().getLexicalUnitType() == 37) {
            value = property.getLexicalUnit().getStringValue();
            int index = value.lastIndexOf(124);
            if (index != -1) {
                value = (String)property.getPrefixMap().get(value.substring(0, index)) + "|" + value.substring(index + 1);
            }
        } else {
            value = property.getValue();
        }
        Util.setAttribute(attributes, Constants.CSS, propertyName, "css:" + propertyName, "font-family".equals(propertyName) ? Util.processFontFamily(value) : value);
        if (specificity <= 0) {
            Util.setAttribute(attributes, Constants.SPECIF, propertyName, "sp:" + propertyName, "1");
        }
    }

    static String toFootnote(int v) {
        return v > FOOTNOTE_NUMBERS.length ? "*" : FOOTNOTE_NUMBERS[v - 1];
    }

    static String toRoman(int v) {
        return v < 1 ? "" : (v < 4 ? "I" + Util.toRoman(v - 1) : (v < 5 ? "IV" : (v < 9 ? "V" + Util.toRoman(v - 5) : (v < 10 ? "IX" : (v < 40 ? "X" + Util.toRoman(v - 10) : (v < 50 ? "XL" + Util.toRoman(v - 40) : (v < 90 ? "L" + Util.toRoman(v - 50) : (v < 100 ? "XC" + Util.toRoman(v - 90) : (v < 400 ? "C" + Util.toRoman(v - 100) : (v < 500 ? "CD" + Util.toRoman(v - 400) : (v < 900 ? "D" + Util.toRoman(v - 500) : (v < 1000 ? "CM" + Util.toRoman(v - 900) : "M" + Util.toRoman(v - 1000)))))))))))));
    }

    static interface PostProjectionFilter {
        public XMLFilterImpl getFilter();

        public void setBaseUrl(URL var1);
    }
}

