
"""
    This code was generated by Codezu.     

    Changes to this file may cause incorrect behavior and will be lost if
    the code is regenerated.
"""


from mozurestsdk.mozuclient import default as default_client
from mozurestsdk.mozuurl import MozuUrl;
from mozurestsdk.urllocation import UrlLocation
from mozurestsdk.apicontext import ApiContext;

class ExtendedProperty(object):
	def __init__(self, apiContext: ApiContext = None, mozuClient = None):
		self.client = mozuClient or default_client();
		client.withApiContext(apiContext);
	
	def getExtendedProperties(self,orderId, draft = False):
		""" orders-extendedproperties Get GetExtendedProperties description DOCUMENT_HERE 
		
		Args:
			| orderId (string) - Unique identifier of the order.
			| draft (bool) - If true, retrieve the draft version of the order, which might include uncommitted changes to the order or its components.
		
		Returns:
			| array of ExtendedProperty 
		
		Raises:
			| ApiException
		
		"""

		url = MozuUrl("/api/commerce/orders/{orderId}/extendedproperties?draft={draft}", "GET", UrlLocation.TenantPod, False);
		url.formatUrl("draft", draft);
		url.formatUrl("orderId", orderId);
		self.client.withResourceUrl(url).execute();
		return self.client.result();

	
		
	def addExtendedProperties(self,extendedProperties, orderId, updateMode = None, version = None):
		""" orders-extendedproperties Post AddExtendedProperties description DOCUMENT_HERE 
		
		Args:
			| extendedProperties(array|extendedProperties) - Mozu.CommerceRuntime.Contracts.Commerce.ExtendedProperty ApiType DOCUMENT_HERE 
			| orderId (string) - Unique identifier of the order.
			| updateMode (string) - Specifies whether to update the original order, update the order in draft mode, or update the order in draft mode and then commit the changes to the original. Draft mode enables users to make incremental order changes before committing the changes to the original order. Valid values are "ApplyToOriginal," "ApplyToDraft," or "ApplyAndCommit."
			| version (string) - Determines whether or not to check versioning of items for concurrency purposes.
		
		Returns:
			| array of ExtendedProperty 
		
		Raises:
			| ApiException
		
		"""

		url = MozuUrl("/api/commerce/orders/{orderId}/extendedproperties?updatemode={updateMode}&version={version}", "POST", UrlLocation.TenantPod, False);
		url.formatUrl("orderId", orderId);
		url.formatUrl("updateMode", updateMode);
		url.formatUrl("version", version);
		self.client.withResourceUrl(url).withBody(extendedProperties).execute();
		return self.client.result();

	
		
	def updateExtendedProperty(self,extendedProperty, orderId, key, updateMode = None, version = None, upsert = False, responseFields = None):
		""" orders-extendedproperties Put UpdateExtendedProperty description DOCUMENT_HERE 
		
		Args:
			| extendedProperty(extendedProperty) - Mozu.CommerceRuntime.Contracts.Commerce.ExtendedProperty ApiType DOCUMENT_HERE 
			| orderId (string) - Unique identifier of the order.
			| key (string) - 
			| updateMode (string) - Specifies whether to update the original order, update the order in draft mode, or update the order in draft mode and then commit the changes to the original. Draft mode enables users to make incremental order changes before committing the changes to the original order. Valid values are "ApplyToOriginal," "ApplyToDraft," or "ApplyAndCommit."
			| version (string) - Determines whether or not to check versioning of items for concurrency purposes.
			| upsert (bool) - 
			| responseFields (string) - A list or array of fields returned for a call. These fields may be customized and may be used for various types of data calls in Mozu. For example, responseFields are returned for retrieving or updating attributes, carts, and messages in Mozu.
		
		Returns:
			| ExtendedProperty 
		
		Raises:
			| ApiException
		
		"""

		url = MozuUrl("/api/commerce/orders/{orderId}/extendedproperties/{key}?updatemode={updateMode}&version={version}&upsert={upsert}&responseFields={responseFields}", "PUT", UrlLocation.TenantPod, False);
		url.formatUrl("key", key);
		url.formatUrl("orderId", orderId);
		url.formatUrl("responseFields", responseFields);
		url.formatUrl("updateMode", updateMode);
		url.formatUrl("upsert", upsert);
		url.formatUrl("version", version);
		self.client.withResourceUrl(url).withBody(extendedProperty).execute();
		return self.client.result();

	
		
	def updateExtendedProperties(self,extendedProperties, orderId, updateMode = None, version = None, upsert = False):
		""" orders-extendedproperties Put UpdateExtendedProperties description DOCUMENT_HERE 
		
		Args:
			| extendedProperties(array|extendedProperties) - Mozu.CommerceRuntime.Contracts.Commerce.ExtendedProperty ApiType DOCUMENT_HERE 
			| orderId (string) - Unique identifier of the order.
			| updateMode (string) - Specifies whether to update the original order, update the order in draft mode, or update the order in draft mode and then commit the changes to the original. Draft mode enables users to make incremental order changes before committing the changes to the original order. Valid values are "ApplyToOriginal," "ApplyToDraft," or "ApplyAndCommit."
			| version (string) - Determines whether or not to check versioning of items for concurrency purposes.
			| upsert (bool) - 
		
		Returns:
			| array of ExtendedProperty 
		
		Raises:
			| ApiException
		
		"""

		url = MozuUrl("/api/commerce/orders/{orderId}/extendedproperties?updatemode={updateMode}&version={version}&upsert={upsert}", "PUT", UrlLocation.TenantPod, False);
		url.formatUrl("orderId", orderId);
		url.formatUrl("updateMode", updateMode);
		url.formatUrl("upsert", upsert);
		url.formatUrl("version", version);
		self.client.withResourceUrl(url).withBody(extendedProperties).execute();
		return self.client.result();

	
		
	def deleteExtendedProperty(self,orderId, key, updateMode = None, version = None):
		""" orders-extendedproperties Delete DeleteExtendedProperty description DOCUMENT_HERE 
		
		Args:
			| orderId (string) - Unique identifier of the order.
			| key (string) - 
			| updateMode (string) - Specifies whether to update the original order, update the order in draft mode, or update the order in draft mode and then commit the changes to the original. Draft mode enables users to make incremental order changes before committing the changes to the original order. Valid values are "ApplyToOriginal," "ApplyToDraft," or "ApplyAndCommit."
			| version (string) - Determines whether or not to check versioning of items for concurrency purposes.
		
		Raises:
			| ApiException
		
		"""

		url = MozuUrl("/api/commerce/orders/{orderId}/extendedproperties/{key}?updatemode={updateMode}&version={version}", "DELETE", UrlLocation.TenantPod, False);
		url.formatUrl("key", key);
		url.formatUrl("orderId", orderId);
		url.formatUrl("updateMode", updateMode);
		url.formatUrl("version", version);
		self.client.withResourceUrl(url).execute();

	
		
	def deleteExtendedProperties(self,keys, orderId, updateMode = None, version = None):
		""" orders-extendedproperties Delete DeleteExtendedProperties description DOCUMENT_HERE 
		
		Args:
			| keys(array|keys) - 
			| orderId (string) - Unique identifier of the order.
			| updateMode (string) - Specifies whether to update the original order, update the order in draft mode, or update the order in draft mode and then commit the changes to the original. Draft mode enables users to make incremental order changes before committing the changes to the original order. Valid values are "ApplyToOriginal," "ApplyToDraft," or "ApplyAndCommit."
			| version (string) - Determines whether or not to check versioning of items for concurrency purposes.
		
		Raises:
			| ApiException
		
		"""

		url = MozuUrl("/api/commerce/orders/{orderId}/extendedproperties?updatemode={updateMode}&version={version}", "DELETE", UrlLocation.TenantPod, False);
		url.formatUrl("orderId", orderId);
		url.formatUrl("updateMode", updateMode);
		url.formatUrl("version", version);
		self.client.withResourceUrl(url).withBody(keys).execute();

	
	
	