# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class ImageInsightsImageCaption(Model):
    """Defines an image's caption.

    :param caption: A caption about the image.
    :type caption: str
    :param data_source_url: The URL to the website where the caption was
     found. You must attribute the caption to the source. For example, by
     displaying the domain name from the URL next to the caption and using the
     URL to link to the source website.
    :type data_source_url: str
    :param related_searches: A list of entities found in the caption. Use the
     contents of the Query object to find the entity in the caption and create
     a link. The link takes the user to images of the entity.
    :type related_searches:
     list[~azure.cognitiveservices.search.imagesearch.models.Query]
    """

    _validation = {
        'caption': {'required': True},
        'data_source_url': {'required': True},
        'related_searches': {'required': True},
    }

    _attribute_map = {
        'caption': {'key': 'caption', 'type': 'str'},
        'data_source_url': {'key': 'dataSourceUrl', 'type': 'str'},
        'related_searches': {'key': 'relatedSearches', 'type': '[Query]'},
    }

    def __init__(self, caption, data_source_url, related_searches):
        super(ImageInsightsImageCaption, self).__init__()
        self.caption = caption
        self.data_source_url = data_source_url
        self.related_searches = related_searches
