/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.proactive.scheduler.common.job.factories;

import java.util.Map;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.ow2.proactive.scheduler.common.job.JobVariable;
import org.ow2.proactive.scheduler.common.job.factories.XMLAttributes;
import org.ow2.proactive.scheduler.common.job.factories.XMLTags;

public class GetJobContentGenerator {
    private static final String FOUR_SPACES_INDENT = "    ";
    private static final String TWO_SPACES_INDENT = "  ";
    private static final String TAG_WITH_TWO_ATTRIBUTES = "<%s %s=\"%s\" %s=\"%s\" />";
    private static final String TAG_WITH_THREE_ATTRIBUTES = "<%s %s=\"%s\" %s=\"%s\" %s=\"%s\" />";

    public String replaceVarsAndGenericInfo(String jobContent, Map<String, JobVariable> variables, Map<String, String> genericInformation) {
        int sizeOfFirstPart = jobContent.indexOf(XMLTags.TASK_FLOW.getXMLName());
        String replacedJobContent = this.replaceVarsContent(jobContent, this.newVariablesContent(variables), sizeOfFirstPart);
        sizeOfFirstPart = replacedJobContent.indexOf(XMLTags.TASK_FLOW.getXMLName());
        replacedJobContent = this.replaceGenericInfoContent(replacedJobContent, this.newGenericInfoContent(genericInformation), sizeOfFirstPart);
        return replacedJobContent;
    }

    private String newGenericInfoContent(Map<String, String> genericInformation) {
        if (!genericInformation.isEmpty()) {
            return genericInformation.entrySet().stream().map(this::genericInfoContent).map(s -> s + System.lineSeparator()).reduce("", String::concat);
        }
        return "";
    }

    private String genericInfoContent(Map.Entry<String, String> pair) {
        return String.format("    <%s %s=\"%s\" %s=\"%s\" />", new Object[]{XMLTags.COMMON_INFO, XMLAttributes.COMMON_NAME, pair.getKey(), XMLAttributes.COMMON_VALUE, pair.getValue()});
    }

    private String replaceGenericInfoContent(String jobContent, String newContent, int end) {
        String firstHalf = jobContent.substring(0, end);
        String untouchablePart = jobContent.substring(end);
        Optional<Matcher> openMatcher = this.indexOfPattern(firstHalf, XMLTags.COMMON_GENERIC_INFORMATION.getOpenTagPattern());
        Optional<Matcher> closeMatcher = this.indexOfPattern(firstHalf, XMLTags.COMMON_GENERIC_INFORMATION.getCloseTagPattern());
        if (openMatcher.isPresent() && closeMatcher.isPresent()) {
            int beforeOpenTag = openMatcher.get().start();
            int afterOpenTag = openMatcher.get().end();
            int beforeCloseTag = closeMatcher.get().start();
            int afterCloseTag = closeMatcher.get().end();
            if (!newContent.isEmpty()) {
                return this.insertContent(firstHalf, newContent, afterOpenTag, beforeCloseTag) + untouchablePart;
            }
            String left = firstHalf.substring(0, beforeOpenTag);
            String right = firstHalf.substring(afterCloseTag + 1).trim();
            return left + right + untouchablePart;
        }
        if (!newContent.isEmpty()) {
            XMLTags[] xmlTags = new XMLTags[]{XMLTags.COMMON_DESCRIPTION, XMLTags.VARIABLES};
            for (XMLTags xmlTag : xmlTags) {
                Optional<Integer> afterCloseTag = this.afterCloseTag(firstHalf, xmlTag);
                if (!afterCloseTag.isPresent()) continue;
                return this.insertContent(firstHalf, XMLTags.COMMON_GENERIC_INFORMATION.withContent(newContent), afterCloseTag.get()) + untouchablePart;
            }
            Optional<Integer> afterOpenTag = this.afterOpenTag(firstHalf, XMLTags.JOB);
            return afterOpenTag.map(index -> this.insertContent(firstHalf, XMLTags.COMMON_GENERIC_INFORMATION.withContent(newContent), (int)index) + untouchablePart).orElse(jobContent);
        }
        return jobContent;
    }

    private String replaceVarsContent(String jobContent, String newContent, int end) {
        String firstHalf = jobContent.substring(0, end);
        String untouchablePart = jobContent.substring(end);
        Optional<Matcher> openMatcher = this.indexOfPattern(firstHalf, XMLTags.VARIABLES.getOpenTagPattern());
        Optional<Matcher> closeMatcher = this.indexOfPattern(firstHalf, XMLTags.VARIABLES.getCloseTagPattern());
        if (openMatcher.isPresent() && closeMatcher.isPresent()) {
            int beforeOpenTag = openMatcher.get().start();
            int afterOpenTag = openMatcher.get().end();
            int beforeCloseTag = closeMatcher.get().start();
            int afterCloseTag = closeMatcher.get().end();
            if (!newContent.isEmpty()) {
                String beforeNewContent = firstHalf.substring(0, afterOpenTag) + System.lineSeparator();
                String afterNewContent = TWO_SPACES_INDENT + firstHalf.substring(beforeCloseTag);
                return beforeNewContent + newContent + afterNewContent + untouchablePart;
            }
            String beforeNewContent = firstHalf.substring(0, beforeOpenTag);
            String afterNewContent = firstHalf.substring(afterCloseTag + 1).trim();
            return beforeNewContent + afterNewContent + untouchablePart;
        }
        if (!newContent.isEmpty()) {
            Optional<Integer> afterOpenTag = this.afterOpenTag(firstHalf, XMLTags.JOB);
            return afterOpenTag.map(index -> this.insertContent(firstHalf, XMLTags.VARIABLES.withContent(newContent), (int)index) + untouchablePart).orElse(jobContent);
        }
        return jobContent;
    }

    private String insertContent(String all, String content, int index) {
        String left = all.substring(0, index) + System.lineSeparator();
        String right = TWO_SPACES_INDENT + all.substring(index);
        StringBuilder result = new StringBuilder();
        result.append(left);
        result.append(content);
        result.append(right);
        return result.toString();
    }

    private String insertContent(String all, String content, int index, int index2) {
        String left = all.substring(0, index);
        String right = TWO_SPACES_INDENT + all.substring(index2);
        return left + System.lineSeparator() + content + right;
    }

    private Optional<Integer> afterOpenTag(String content, XMLTags tag) {
        return this.indexOfPattern(content, tag.getOpenTagPattern()).map(Matcher::end);
    }

    private Optional<Integer> afterCloseTag(String content, XMLTags tag) {
        return this.indexOfPattern(content, tag.getCloseTagPattern()).map(Matcher::end);
    }

    private Optional<Matcher> indexOfPattern(String content, String pattern) {
        Pattern aPattern = Pattern.compile(pattern);
        Matcher matcher = aPattern.matcher(content);
        if (matcher.find()) {
            return Optional.of(matcher);
        }
        return Optional.empty();
    }

    private String newVariablesContent(Map<String, JobVariable> variables) {
        if (!variables.isEmpty()) {
            return variables.values().stream().map(this::variableContent).map(s -> s + System.lineSeparator()).reduce("", String::concat);
        }
        return "";
    }

    private String variableContent(JobVariable jobVariable) {
        if (jobVariable.getModel() != null && !jobVariable.getModel().trim().isEmpty()) {
            return String.format("    <%s %s=\"%s\" %s=\"%s\" %s=\"%s\" />", new Object[]{XMLTags.VARIABLE.getXMLName(), XMLAttributes.VARIABLE_NAME, jobVariable.getName(), XMLAttributes.VARIABLE_VALUE, jobVariable.getValue(), XMLAttributes.VARIABLE_MODEL, jobVariable.getModel()});
        }
        return String.format("    <%s %s=\"%s\" %s=\"%s\" />", new Object[]{XMLTags.VARIABLE.getXMLName(), XMLAttributes.VARIABLE_NAME, jobVariable.getName(), XMLAttributes.VARIABLE_VALUE, jobVariable.getValue()});
    }
}

