/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.proactive.scheduler.common.job.factories.spi.model.factory;

import org.ow2.proactive.scheduler.common.job.factories.spi.model.converter.Converter;
import org.ow2.proactive.scheduler.common.job.factories.spi.model.converter.IdentityConverter;
import org.ow2.proactive.scheduler.common.job.factories.spi.model.exceptions.ModelSyntaxException;
import org.ow2.proactive.scheduler.common.job.factories.spi.model.factory.BaseParserValidator;
import org.ow2.proactive.scheduler.common.job.factories.spi.model.validator.CRONValidator;
import org.ow2.proactive.scheduler.common.job.factories.spi.model.validator.Validator;

public class CRONParserValidator
extends BaseParserValidator<String> {
    public static final String CRON_TYPE = "CRON";
    protected static final String CRON_TYPE_REGEXP = "[Cc][Rr][Oo][Nn]";

    public CRONParserValidator(String model) throws ModelSyntaxException {
        super(model);
        String regexep = "^[Cc][Rr][Oo][Nn]$";
        if (!model.matches(regexep)) {
            throw new ModelSyntaxException("CRON expression in model does not match " + regexep);
        }
    }

    @Override
    public String getType() {
        return CRON_TYPE;
    }

    @Override
    public String getTypeRegexp() {
        return CRON_TYPE_REGEXP;
    }

    @Override
    public Class getClassType() {
        return String.class;
    }

    @Override
    protected Converter<String> createConverter(String model) throws ModelSyntaxException {
        return new IdentityConverter();
    }

    @Override
    protected Validator<String> createValidator(String model, Converter<String> converter) throws ModelSyntaxException {
        return new CRONValidator();
    }
}

