/*
 * Decompiled with CFR 0.152.
 */
package jdbm.recman;

import java.io.IOException;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import java.util.Iterator;
import jdbm.RecordManager;
import jdbm.Serializer;
import jdbm.helper.LongHashMap;
import jdbm.helper.RecordManagerImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CacheRecordManager
extends RecordManagerImpl {
    protected RecordManager _recman;
    protected LongHashMap<CacheEntry> _hash;
    protected LongHashMap<SoftCacheEntry> _softHash;
    protected ReferenceQueue<SoftCacheEntry> _refQueue;
    protected int _max;
    protected boolean _softCache;
    protected Thread _softRefThread;
    protected static int threadCounter = 0;
    protected CacheEntry _first;
    protected CacheEntry _last;
    private boolean disableUpdateCache = false;

    public CacheRecordManager(RecordManager recman, int maxRecords, boolean softCache) {
        if (recman == null) {
            throw new IllegalArgumentException("Argument 'recman' is null");
        }
        this._hash = new LongHashMap(maxRecords);
        this._recman = recman;
        this._max = maxRecords;
        this._softCache = softCache;
        if (softCache) {
            this._softHash = new LongHashMap();
            this._refQueue = new ReferenceQueue();
            this._softRefThread = new Thread((Runnable)new SoftRunnable(this, this._refQueue), "JDBM Soft Cache Disposer " + threadCounter++);
            this._softRefThread.setDaemon(true);
            this._softRefThread.start();
        }
    }

    public RecordManager getRecordManager() {
        return this._recman;
    }

    @Override
    public synchronized <A> long insert(A obj, Serializer<A> serializer) throws IOException {
        this.checkIfClosed();
        long recid = this._recman.insert(obj, serializer);
        return recid;
    }

    @Override
    public synchronized <A> A fetch(long recid, Serializer<A> serializer, boolean disableCache) throws IOException {
        return this._recman.fetch(recid, serializer, disableCache);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void delete(long recid) throws IOException {
        this.checkIfClosed();
        this._recman.delete(recid);
        CacheEntry entry = this._hash.get(recid);
        if (entry != null) {
            this.removeEntry(entry);
            this._hash.remove(entry._recid);
        }
        if (this._softCache) {
            LongHashMap<SoftCacheEntry> longHashMap = this._softHash;
            synchronized (longHashMap) {
                SoftCacheEntry e = this._softHash.remove(recid);
                if (e != null) {
                    e.clear();
                    e._serializer = null;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized <A> void update(long recid, A obj, Serializer<A> serializer) throws IOException {
        this.checkIfClosed();
        if (this._softCache) {
            LongHashMap<SoftCacheEntry> longHashMap = this._softHash;
            synchronized (longHashMap) {
                SoftCacheEntry e = this._softHash.remove(recid);
                if (e != null) {
                    e.clear();
                    e._serializer = null;
                }
            }
        }
        if (this.disableUpdateCache) {
            this._recman.update(recid, obj, serializer);
        } else {
            CacheEntry entry = this.cacheGet(recid);
            if (entry != null) {
                entry._obj = obj;
                entry._serializer = serializer;
                entry._isDirty = true;
            } else {
                this.cachePut(recid, obj, serializer, true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized <A> A fetch(long recid, Serializer<A> serializer) throws IOException {
        CacheEntry entry;
        this.checkIfClosed();
        if (this._softCache) {
            LongHashMap<SoftCacheEntry> longHashMap = this._softHash;
            synchronized (longHashMap) {
                Object a;
                SoftCacheEntry e = this._softHash.get(recid);
                if (e != null && (a = e.get()) != null) {
                    return (A)a;
                }
            }
        }
        if ((entry = this.cacheGet(recid)) == null) {
            A value = this._recman.fetch(recid, serializer);
            if (!this._softCache) {
                this.cachePut(recid, value, serializer, false);
            } else {
                LongHashMap<SoftCacheEntry> longHashMap = this._softHash;
                synchronized (longHashMap) {
                    this._softHash.put(recid, new SoftCacheEntry(recid, value, serializer, this._refQueue));
                }
            }
            return value;
        }
        return (A)entry._obj;
    }

    @Override
    public synchronized void close() throws IOException {
        this.checkIfClosed();
        this.updateCacheEntries();
        this._recman.close();
        this._recman = null;
        this._hash = null;
        this._softHash = null;
        if (this._softCache) {
            this._softRefThread.interrupt();
        }
    }

    @Override
    public synchronized void commit() throws IOException {
        this.checkIfClosed();
        this.updateCacheEntries();
        this._recman.commit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void rollback() throws IOException {
        this.checkIfClosed();
        this._recman.rollback();
        this._hash.clear();
        if (this._softCache) {
            LongHashMap<SoftCacheEntry> longHashMap = this._softHash;
            synchronized (longHashMap) {
                Iterator<SoftCacheEntry> iter = this._softHash.valuesIterator();
                while (iter.hasNext()) {
                    SoftCacheEntry e = iter.next();
                    e.clear();
                    e._serializer = null;
                }
                this._softHash.clear();
            }
        }
        this._first = null;
        this._last = null;
    }

    @Override
    public synchronized long getNamedObject(String name) throws IOException {
        this.checkIfClosed();
        return this._recman.getNamedObject(name);
    }

    @Override
    public synchronized void setNamedObject(String name, long recid) throws IOException {
        this.checkIfClosed();
        this._recman.setNamedObject(name, recid);
    }

    private void checkIfClosed() throws IllegalStateException {
        if (this._recman == null) {
            throw new IllegalStateException("RecordManager has been closed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateCacheEntries() throws IOException {
        try {
            if (this.disableUpdateCache) {
                throw new InternalError("already inside purging entry");
            }
            this.disableUpdateCache = true;
            Iterator<CacheEntry> iter = this._hash.valuesIterator();
            while (iter.hasNext()) {
                CacheEntry entry = iter.next();
                if (!entry._isDirty) continue;
                this._recman.update(entry._recid, entry._obj, entry._serializer);
                entry._isDirty = false;
            }
        }
        finally {
            this.disableUpdateCache = false;
        }
    }

    protected CacheEntry cacheGet(long key) {
        CacheEntry entry = this._hash.get(key);
        if (entry != null) {
            this.touchEntry(entry);
        }
        return entry;
    }

    protected void cachePut(long recid, Object value, Serializer serializer, boolean dirty) throws IOException {
        CacheEntry entry = this._hash.get(recid);
        if (entry != null) {
            entry._obj = value;
            entry._serializer = serializer;
            this.touchEntry(entry);
        } else {
            if (this._hash.size() == this._max) {
                entry = this.purgeEntry();
                entry._recid = recid;
                entry._obj = value;
                entry._isDirty = dirty;
                entry._serializer = serializer;
            } else {
                entry = new CacheEntry(recid, value, serializer, dirty);
            }
            this.addEntry(entry);
            this._hash.put(entry._recid, entry);
        }
    }

    protected void addEntry(CacheEntry entry) {
        if (this._first == null) {
            this._first = entry;
            this._last = entry;
        } else {
            this._last._next = entry;
            entry._previous = this._last;
            this._last = entry;
        }
    }

    protected void removeEntry(CacheEntry entry) {
        if (entry == this._first) {
            this._first = entry._next;
        }
        if (this._last == entry) {
            this._last = entry._previous;
        }
        CacheEntry previous = entry._previous;
        CacheEntry next = entry._next;
        if (previous != null) {
            previous._next = next;
        }
        if (next != null) {
            next._previous = previous;
        }
        entry._previous = null;
        entry._next = null;
    }

    protected void touchEntry(CacheEntry entry) {
        if (this._last == entry) {
            return;
        }
        this.removeEntry(entry);
        this.addEntry(entry);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected CacheEntry purgeEntry() throws IOException {
        try {
            if (this.disableUpdateCache) {
                throw new InternalError("already inside purging entry");
            }
            this.disableUpdateCache = true;
            CacheEntry entry = this._first;
            if (entry == null) {
                CacheEntry cacheEntry = new CacheEntry(-1L, null, null, false);
                return cacheEntry;
            }
            if (entry._isDirty) {
                this._recman.update(entry._recid, entry._obj, entry._serializer);
            }
            this.removeEntry(entry);
            this._hash.remove(entry._recid);
            entry._obj = null;
            entry._serializer = null;
            entry._isDirty = false;
            CacheEntry cacheEntry = entry;
            return cacheEntry;
        }
        finally {
            this.disableUpdateCache = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearCache() throws IOException {
        while (this._hash.size() > 0) {
            this.purgeEntry();
        }
        if (this._softCache) {
            LongHashMap<SoftCacheEntry> longHashMap = this._softHash;
            synchronized (longHashMap) {
                Iterator<SoftCacheEntry> iter = this._softHash.valuesIterator();
                while (iter.hasNext()) {
                    SoftCacheEntry e = iter.next();
                    e.clear();
                    e._serializer = null;
                }
                this._softHash.clear();
            }
        }
        this._first = null;
        this._last = null;
    }

    @Override
    public void defrag() throws IOException {
        this.commit();
        this._recman.defrag();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static final class SoftRunnable
    implements Runnable {
        private ReferenceQueue<SoftCacheEntry> entryQueue;
        private WeakReference<CacheRecordManager> recman2;

        public SoftRunnable(CacheRecordManager recman, ReferenceQueue<SoftCacheEntry> entryQueue) {
            this.recman2 = new WeakReference<CacheRecordManager>(recman);
            this.entryQueue = entryQueue;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (true) {
                try {
                    CacheRecordManager recman;
                    SoftCacheEntry e;
                    do {
                        e = (SoftCacheEntry)this.entryQueue.remove(10000L);
                        recman = (CacheRecordManager)this.recman2.get();
                        if (recman != null) continue;
                        return;
                    } while (e == null);
                    LongHashMap<SoftCacheEntry> longHashMap = recman._softHash;
                    synchronized (longHashMap) {
                        while (e != null) {
                            recman._softHash.remove(e._recid);
                            e = (SoftCacheEntry)this.entryQueue.poll();
                        }
                        continue;
                    }
                }
                catch (InterruptedException e) {
                    return;
                }
                catch (Throwable e) {
                    e.printStackTrace();
                    continue;
                }
                break;
            }
        }
    }

    protected static final class SoftCacheEntry
    extends SoftReference {
        protected long _recid;
        protected Serializer _serializer;

        SoftCacheEntry(long recid, Object obj, Serializer serializer, ReferenceQueue queue) {
            super(obj, queue);
            this._recid = recid;
            this._serializer = serializer;
        }
    }

    protected static final class CacheEntry {
        protected long _recid;
        protected Object _obj;
        protected Serializer _serializer;
        protected boolean _isDirty;
        protected CacheEntry _previous;
        protected CacheEntry _next;

        CacheEntry(long recid, Object obj, Serializer serializer, boolean isDirty) {
            this._recid = recid;
            this._obj = obj;
            this._serializer = serializer;
            this._isDirty = isDirty;
        }
    }
}

