/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.proactive.core.properties;

import java.io.File;
import java.util.List;
import java.util.Map;
import org.ow2.proactive.core.properties.PACommonProperties;
import org.ow2.proactive.core.properties.PACommonPropertiesHelper;
import org.ow2.proactive.core.properties.PropertyType;
import org.ow2.proactive.utils.PAPropertiesLazyLoader;

public enum PASharedProperties implements PACommonProperties
{
    SHARED_HOME("pa.rm.home", PropertyType.STRING),
    PROPERTIES_CRYPT_KEY("pa.shared.properties.crypt.key", PropertyType.STRING, "activeeon");

    public static final String PA_SHARED_PROPERTIES_FILEPATH = "pa.shared.properties.filepath";
    public static final String PA_SHARED_PROPERTIES_RELATIVE_FILEPATH = "config/shared/settings.ini";
    private static PAPropertiesLazyLoader propertiesLoader;
    private static PACommonPropertiesHelper propertiesHelper;
    private String key;
    private PropertyType type;
    private String defaultValue;

    private PASharedProperties(String str, PropertyType type, String defaultValue) {
        this.key = str;
        this.type = type;
        this.defaultValue = defaultValue;
    }

    private PASharedProperties(String str, PropertyType type) {
        this(str, type, null);
    }

    protected static void loadProperties(String filename) {
        propertiesLoader = new PAPropertiesLazyLoader(PASharedProperties.SHARED_HOME.key, PA_SHARED_PROPERTIES_FILEPATH, PA_SHARED_PROPERTIES_RELATIVE_FILEPATH, filename);
        propertiesHelper = new PACommonPropertiesHelper(propertiesLoader);
    }

    public static synchronized void reload() {
        propertiesLoader = new PAPropertiesLazyLoader(PASharedProperties.SHARED_HOME.key, PA_SHARED_PROPERTIES_FILEPATH, PA_SHARED_PROPERTIES_RELATIVE_FILEPATH);
        propertiesHelper = new PACommonPropertiesHelper(propertiesLoader);
    }

    public static void updateProperties(String filename) {
        propertiesHelper.updateProperties(filename);
    }

    public static Map<String, Object> getPropertiesAsHashMap() {
        return propertiesHelper.getPropertiesAsHashMap();
    }

    public static String getAbsolutePath(String userPath) {
        if (new File(userPath).isAbsolute()) {
            return userPath;
        }
        return SHARED_HOME.getValueAsString() + File.separator + userPath;
    }

    @Override
    public String getConfigurationFilePathPropertyName() {
        return PA_SHARED_PROPERTIES_FILEPATH;
    }

    @Override
    public String getConfigurationDefaultRelativeFilePath() {
        return PA_SHARED_PROPERTIES_RELATIVE_FILEPATH;
    }

    @Override
    public void loadPropertiesFromFile(String filename) {
        PASharedProperties.loadProperties(filename);
    }

    @Override
    public void reloadConfiguration() {
        PASharedProperties.reload();
    }

    @Override
    public String getKey() {
        return this.key;
    }

    @Override
    public void updateProperty(String value) {
        propertiesHelper.updateProperty(this.key, value);
    }

    @Override
    public boolean isSet() {
        return propertiesHelper.isSet(this.key, this.defaultValue);
    }

    @Override
    public void unSet() {
        propertiesHelper.unSet(this.key);
    }

    @Override
    public String getCmdLine() {
        return propertiesHelper.getCmdLine(this.key);
    }

    @Override
    public int getValueAsInt() {
        return propertiesHelper.getValueAsInt(this.key, this.type, this.defaultValue);
    }

    @Override
    public long getValueAsLong() {
        return propertiesHelper.getValueAsLong(this.key, this.type, this.defaultValue);
    }

    @Override
    public String getValueAsString() {
        return propertiesHelper.getValueAsString(this.key, this.defaultValue);
    }

    @Override
    public String getValueAsStringOrNull() {
        return propertiesHelper.getValueAsStringOrNull(this.key);
    }

    @Override
    public boolean getValueAsBoolean() {
        return propertiesHelper.getValueAsBoolean(this.key, this.type, this.defaultValue);
    }

    @Override
    public List<String> getValueAsList(String separator) {
        return propertiesHelper.getValueAsList(this.key, this.type, separator, this.defaultValue);
    }

    @Override
    public PropertyType getType() {
        return this.type;
    }

    public String toString() {
        return this.getValueAsString();
    }

    static {
        PASharedProperties.reload();
    }
}

